/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildAgent;
import com.microsoft.tfs.core.clients.build.IBuildController;
import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IBuildServiceHost;
import com.microsoft.tfs.core.clients.build.flags.BuildAgentUpdate;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.AttachedPropertyDictionary;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgentUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildController;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.clients.build.soapextensions.AgentStatus;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.datetime.DotNETDate;
import java.util.Calendar;
import java.util.TreeSet;
import ms.tfs.build.buildservice._04._BuildAgent;
import ms.tfs.build.buildservice._04._PropertyValue;

public class BuildAgent
extends WebServiceObjectWrapper
implements IBuildAgent {
    private IBuildController controller;
    private IBuildServiceHost serviceHost;
    private BuildAgentUpdateOptions lastSnapshot;
    private final Object lockProperties = new Object();
    private AttachedPropertyDictionary attachedProperties;

    private BuildAgent(IBuildServiceHost serviceHost) {
        super(new _BuildAgent());
        this.serviceHost = serviceHost;
        _BuildAgent _o = this.getWebServiceObject();
        _o.setDateCreated(DotNETDate.MIN_CALENDAR);
        _o.setDateUpdated(DotNETDate.MIN_CALENDAR);
        _o.setStatus(AgentStatus.UNAVAILABLE.getWebServiceObject());
        _o.setTags(new String[0]);
        _o.setProperties(new _PropertyValue[0]);
    }

    public BuildAgent(IBuildServiceHost serviceHost, _BuildAgent webServiceObject) {
        super(webServiceObject);
        this.serviceHost = serviceHost;
    }

    public BuildAgent(IBuildServiceHost serviceHost, String name, String buildDirectory) {
        this(serviceHost);
        _BuildAgent _o = this.getWebServiceObject();
        _o.setName(name);
        _o.setBuildDirectory(buildDirectory);
        this.lastSnapshot = this.getSnapshot();
        _o.setStatus(AgentStatus.OFFLINE.getWebServiceObject());
        _o.setEnabled(true);
    }

    public BuildAgent(IBuildServiceHost serviceHost, BuildAgent2010 agent) {
        this(serviceHost);
        _BuildAgent _o = this.getWebServiceObject();
        _o.setBuildDirectory(agent.getBuildDirectory());
        _o.setControllerUri(agent.getControllerURI());
        _o.setDateCreated(agent.getDateCreated());
        _o.setDateUpdated(agent.getDateUpdated());
        _o.setDescription(agent.getDescription());
        _o.setEnabled(agent.isEnabled());
        _o.setName(agent.getName());
        _o.setReservedForBuild(agent.getReservedForBuild());
        _o.setServiceHostUri(agent.getServiceHostURI());
        _o.setStatus(TFS2010Helper.convert(agent.getStatus()).getWebServiceObject());
        _o.setStatusMessage(agent.getStatusMessage());
        _o.setTags(agent.getTags());
        _o.setUri(agent.getURI());
        _o.setUrl(agent.getURL());
    }

    public _BuildAgent getWebServiceObject() {
        return (_BuildAgent)this.webServiceObject;
    }

    @Override
    public String getBuildDirectory() {
        return this.getWebServiceObject().getBuildDirectory();
    }

    @Override
    public void setBuildDirectory(String value) {
        this.getWebServiceObject().setBuildDirectory(value);
    }

    public String getControllerURI() {
        return this.getWebServiceObject().getControllerUri();
    }

    @Override
    public Calendar getDateCreated() {
        return this.getWebServiceObject().getDateCreated();
    }

    @Override
    public Calendar getDateUpdated() {
        return this.getWebServiceObject().getDateUpdated();
    }

    @Override
    public String getDescription() {
        return this.getWebServiceObject().getDescription();
    }

    @Override
    public void setDescription(String value) {
        this.getWebServiceObject().setDescription(value);
    }

    @Override
    public boolean isEnabled() {
        return this.getWebServiceObject().isEnabled();
    }

    @Override
    public void setEnabled(boolean value) {
        this.getWebServiceObject().setEnabled(value);
    }

    public PropertyValue[] getInternalProperties() {
        return (PropertyValue[])WrapperUtils.wrap(PropertyValue.class, this.getWebServiceObject().getProperties());
    }

    public void setInternalProperties(PropertyValue[] value) {
        this.getWebServiceObject().setProperties((_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, value));
    }

    @Override
    public String getMessageQueueURL() {
        return this.getWebServiceObject().getMessageQueueUrl();
    }

    @Override
    public String getName() {
        return this.getWebServiceObject().getName();
    }

    @Override
    public void setName(String value) {
        this.getWebServiceObject().setName(value);
    }

    @Override
    public String getReservedForBuild() {
        return this.getWebServiceObject().getReservedForBuild();
    }

    public void setReservedForBuild(String value) {
        this.getWebServiceObject().setReservedForBuild(value);
    }

    public String getServiceHostURI() {
        return this.getWebServiceObject().getServiceHostUri();
    }

    @Override
    public AgentStatus getStatus() {
        return AgentStatus.fromWebServiceObject(this.getWebServiceObject().getStatus());
    }

    @Override
    public void setStatus(AgentStatus value) {
        this.getWebServiceObject().setStatus(value.getWebServiceObject());
    }

    @Override
    public String getStatusMessage() {
        return this.getWebServiceObject().getStatusMessage();
    }

    @Override
    public void setStatusMessage(String value) {
        this.getWebServiceObject().setStatusMessage(value);
    }

    @Override
    public String getURI() {
        return this.getWebServiceObject().getUri();
    }

    public void setURI(String value) {
        this.getWebServiceObject().setUri(value);
    }

    @Override
    public String getURL() {
        return this.getWebServiceObject().getUrl();
    }

    public void setURL(String value) {
        this.getWebServiceObject().setUrl(value);
    }

    @Override
    public IBuildServiceHost getServiceHost() {
        return this.serviceHost;
    }

    public void setServiceHost(IBuildServiceHost value) {
        this.serviceHost = value;
        if (this.serviceHost != null) {
            this.getWebServiceObject().setServiceHostUri(this.serviceHost.getURI());
        } else {
            this.getWebServiceObject().setServiceHostUri(null);
        }
    }

    @Override
    public IBuildController getController() {
        return this.controller;
    }

    @Override
    public void setController(IBuildController value) {
        if (this.controller != value) {
            IBuildController oldController = this.controller;
            this.controller = value;
            if (oldController != null) {
                oldController.removeBuildAgent(this);
            }
            if (value == null) {
                this.getWebServiceObject().setControllerUri(null);
            } else {
                this.controller = value;
                this.controller.addBuildAgent(this);
                this.getWebServiceObject().setControllerUri(this.controller.getURI());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachedPropertyDictionary getAttachedProperties() {
        Object object = this.lockProperties;
        synchronized (object) {
            if (this.attachedProperties == null) {
                this.attachedProperties = new AttachedPropertyDictionary();
            }
            return this.attachedProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttachedProperties(AttachedPropertyDictionary value) {
        Object object = this.lockProperties;
        synchronized (object) {
            this.attachedProperties = value;
        }
    }

    @Override
    public String[] getTags() {
        return this.getWebServiceObject().getTags();
    }

    @Override
    public void setTags(String[] value) {
        this.getWebServiceObject().setTags(value);
    }

    @Override
    public boolean isReserved() {
        return this.getWebServiceObject().getReservedForBuild() != null;
    }

    private BuildAgentUpdate compareSnapshots(BuildAgentUpdateOptions originalValues, BuildAgentUpdateOptions modifiedValues) {
        BuildAgentUpdate result = BuildAgentUpdate.NONE;
        if (!LocalPath.equals(originalValues.getBuildDirectory(), modifiedValues.getBuildDirectory())) {
            result = result.combine(BuildAgentUpdate.BUILD_DIRECTORY);
        }
        if (!originalValues.getControllerURI().equals(modifiedValues.getControllerURI())) {
            result = result.combine(BuildAgentUpdate.CONTROLLER_URI);
        }
        if (!originalValues.getDescription().equals(modifiedValues.getDescription())) {
            result = result.combine(BuildAgentUpdate.DESCRIPTION);
        }
        if (!originalValues.getName().equals(modifiedValues.getName())) {
            result = result.combine(BuildAgentUpdate.NAME);
        }
        if (!originalValues.getStatus().equals(modifiedValues.getStatus())) {
            result = result.combine(BuildAgentUpdate.STATUS);
        }
        if (originalValues.isEnabled() != modifiedValues.isEnabled()) {
            result = result.combine(BuildAgentUpdate.ENABLED);
        }
        if (!originalValues.getStatusMessage().equals(modifiedValues.getStatusMessage())) {
            result = result.combine(BuildAgentUpdate.STATUS_MESSAGE);
        }
        if (modifiedValues.getAttachedProperties().length > 0) {
            result = result.combine(BuildAgentUpdate.ATTACHED_PROPERTIES);
        }
        if (this.tagsDiffer(originalValues.getTags(), modifiedValues.getTags())) {
            result = result.combine(BuildAgentUpdate.TAGS);
        }
        return result;
    }

    private BuildAgentUpdateOptions getSnapshot() {
        BuildAgentUpdateOptions result = new BuildAgentUpdateOptions();
        result.setBuildDirectory(this.getBuildDirectory());
        result.setControllerURI(this.getControllerURI());
        result.setDescription(this.getDescription());
        result.setName(this.getName());
        result.setStatus(this.getStatus());
        result.setEnabled(this.isEnabled());
        result.setStatusMessage(this.getStatusMessage());
        result.setTags(this.getTags());
        result.setURI(this.getURI());
        result.setAttachedProperties(this.getAttachedProperties().getChangedProperties());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildAgentUpdateOptions getUpdateOptions() {
        BuildAgentUpdateOptions currentSnapshot;
        BuildAgentUpdateOptions buildAgentUpdateOptions = this.lastSnapshot;
        synchronized (buildAgentUpdateOptions) {
            currentSnapshot = this.getSnapshot();
            currentSnapshot.setFields(this.compareSnapshots(this.lastSnapshot, currentSnapshot));
        }
        return currentSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateOptions(BuildAgentUpdateOptions snapshot) {
        BuildAgentUpdateOptions buildAgentUpdateOptions = this.lastSnapshot;
        synchronized (buildAgentUpdateOptions) {
            this.lastSnapshot = snapshot;
        }
        this.attachedProperties.clearChangedProperties();
    }

    @Override
    public String getExpandedBuildDirectory(IBuildDefinition definition) {
        throw new NotSupportedException();
    }

    @Override
    public void delete() {
        if (this.getWebServiceObject().getUri() != null) {
            this.serviceHost.getBuildServer().deleteBuildAgents(new String[]{this.getURI()});
            if (this.controller != null) {
                this.controller.removeBuildAgent(this);
            }
        }
    }

    @Override
    public void refresh() {
        if (this.getURI() != null) {
            this.copy(this.getServiceHost().getBuildServer().getBuildAgent(this.getURI()));
        }
    }

    @Override
    public void refresh(String[] propertyNameFilters) {
        if (this.getURI() != null) {
            this.copy(this.serviceHost.getBuildServer().getBuildAgent(this.getURI(), propertyNameFilters));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(IBuildAgent agent) {
        BuildAgentUpdateOptions buildAgentUpdateOptions = this.lastSnapshot;
        synchronized (buildAgentUpdateOptions) {
            if (agent != null) {
                if (this.controller != null && this.controller.getURI().equals(agent.getController().getURI())) {
                    ((BuildController)this.controller).copy(agent.getController(), false);
                } else {
                    this.controller = agent.getController();
                }
                this.setBuildDirectory(agent.getBuildDirectory());
                this.setDescription(agent.getDescription());
                this.setName(agent.getName());
                this.setReservedForBuild(agent.getReservedForBuild());
                this.setStatus(agent.getStatus());
                this.setEnabled(agent.isEnabled());
                this.setStatusMessage(agent.getStatusMessage());
                this.setTags(agent.getTags());
                this.setAttachedProperties(((BuildAgent)agent).getAttachedProperties());
                this.lastSnapshot = this.getSnapshot();
            }
        }
    }

    public void prepareToSave() {
    }

    @Override
    public void save() {
        this.getServiceHost().getBuildServer().saveBuildAgents(new IBuildAgent[]{this});
    }

    @Override
    public String getTeamProject() {
        return "*";
    }

    @Override
    public String getFullPath() {
        StringBuilder sb = new StringBuilder();
        sb.append("\\");
        sb.append(this.getTeamProject());
        sb.append("\\");
        sb.append(this.getName());
        return sb.toString();
    }

    public String getMachineName() {
        return this.serviceHost.getName();
    }

    public void setMachineName(String value) {
        throw new NotSupportedException();
    }

    public IBuildServer getBuildServer() {
        return null;
    }

    private boolean tagsDiffer(String[] t1, String[] t2) {
        if (t1 == null && t2 == null) {
            return false;
        }
        if (t1 == null || t2 == null) {
            return true;
        }
        if (t1.length != t2.length) {
            return true;
        }
        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String s : t1) {
            set.add(s);
        }
        for (String s : t2) {
            if (set.contains(s)) continue;
            return true;
        }
        return false;
    }
}

