/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.build.IBuildController;
import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildDeletionResult;
import com.microsoft.tfs.core.clients.build.IBuildDetail;
import com.microsoft.tfs.core.clients.build.IBuildInformation;
import com.microsoft.tfs.core.clients.build.IBuildInformationNode;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IQueuedBuild;
import com.microsoft.tfs.core.clients.build.exceptions.InvalidFinalStatusException;
import com.microsoft.tfs.core.clients.build.flags.BuildReason;
import com.microsoft.tfs.core.clients.build.flags.BuildStatus;
import com.microsoft.tfs.core.clients.build.flags.BuildUpdate;
import com.microsoft.tfs.core.clients.build.flags.DeleteOptions;
import com.microsoft.tfs.core.clients.build.flags.QueryDeletedOption;
import com.microsoft.tfs.core.clients.build.flags.QueryOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinition;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetail2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformation;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformationNode;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildPhaseStatus;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServer;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.CommonInformationHelper;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuild;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.datetime.DotNETDate;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import ms.tfs.build.buildservice._04._BuildDetail;
import ms.tfs.build.buildservice._04._BuildInformationNode;

public class BuildDetail
extends WebServiceObjectWrapper
implements IBuildDetail {
    private String requestedBy;
    private String requestedFor;
    private String shelvesetName;
    private IBuildController buildController;
    private BuildUpdateOptions lastSnapshot;
    private BuildServer buildServer;
    private BuildDefinition buildDefinition;
    private IBuildInformation informationNodes;
    private int[] requestIds = new int[0];
    private IQueuedBuild[] requests = new IQueuedBuild[0];
    public Object syncSave = new Object();

    public BuildDetail(IBuildServer buildServer, _BuildDetail webServiceObject) {
        super(webServiceObject);
        this.buildServer = (BuildServer)buildServer;
        this.afterDeserialize();
    }

    public _BuildDetail getWebServiceObject() {
        return (_BuildDetail)this.webServiceObject;
    }

    public BuildDetail(IBuildServer buildServer, BuildDetail2010 build2010) {
        super(new _BuildDetail());
        this.buildServer = (BuildServer)buildServer;
        _BuildDetail proxy = this.getWebServiceObject();
        proxy.setBuildControllerUri(build2010.getBuildAgentUri());
        proxy.setBuildDefinitionUri(build2010.getBuildDefinitionUri());
        proxy.setBuildNumber(build2010.getBuildNumber());
        buildServer = build2010.getBuildServer();
        proxy.setCompilationStatus(TFS2010Helper.convert(build2010.getCompilationStatus()).getWebServiceObject());
        proxy.setDropLocation(build2010.getDropLocation());
        proxy.setDropLocationRoot(build2010.getDropLocationRoot());
        proxy.setFinishTime(build2010.getFinishTime());
        proxy.setInformation((_BuildInformationNode[])WrapperUtils.unwrap(_BuildInformationNode.class, TFS2010Helper.convert(build2010.getInternalInformation())));
        proxy.setIsDeleted(build2010.isIsDeleted());
        proxy.setKeepForever(build2010.isKeepForever());
        proxy.setLabelName(build2010.getLabelName());
        proxy.setLastChangedBy(build2010.getLastChangedBy());
        proxy.setLastChangedOn(build2010.getLastChangedOn());
        proxy.setLogLocation(build2010.getLogLocation());
        proxy.setProcessParameters(build2010.getProcessParameters());
        proxy.setQuality(build2010.getQuality());
        proxy.setReason(TFS2010Helper.convert(build2010.getReason()).getWebServiceObject());
        this.requestedBy = build2010.getRequestedBy();
        this.requestedFor = build2010.getRequestedFor();
        this.shelvesetName = build2010.getShelvesetName();
        proxy.setSourceGetVersion(build2010.getSourceGetVersion());
        proxy.setStartTime(build2010.getStartTime());
        proxy.setStatus(TFS2010Helper.convert(build2010.getStatus()).getWebServiceObject());
        proxy.setTeamProject(build2010.getTeamProject());
        proxy.setTestStatus(TFS2010Helper.convert(build2010.getTestStatus()).getWebServiceObject());
        proxy.setUri(build2010.getURI());
        proxy.setQueueIds(new int[]{0});
        QueuedBuild request = new QueuedBuild(buildServer, this);
        this.requests = new IQueuedBuild[1];
        this.requests[0] = request;
        this.afterDeserialize();
    }

    public void afterDeserialize() {
        IBuildInformationNode[] compilationSummaryNodes;
        _BuildDetail proxy = this.getWebServiceObject();
        this.lastSnapshot = this.getSnapshot();
        BuildInformationNode[] info = (BuildInformationNode[])WrapperUtils.wrap(BuildInformationNode.class, proxy.getInformation());
        this.informationNodes = new BuildInformation(this, info);
        this.requestIds = (int[])proxy.getQueueIds().clone();
        if (StringUtil.isNullOrEmpty(proxy.getLastChangedByDisplayName())) {
            proxy.setLastChangedByDisplayName(proxy.getLastChangedBy());
        }
        for (IBuildInformationNode compilationSummaryNode : compilationSummaryNodes = this.informationNodes.getNodesByType("CompilationSummary", true)) {
            if (compilationSummaryNode.getParent() == null) continue;
            IBuildInformationNode node = compilationSummaryNode.getParent().getChildren().createNode();
            Map<String, String> fields = compilationSummaryNode.getFields();
            node.setType("BuildProject");
            node.getFields().put("CompilationErrors", CommonInformationHelper.getString(fields, "CompilationErrors"));
            node.getFields().put("CompilationWarnings", CommonInformationHelper.getString(fields, "CompilationWarnings"));
            node.getFields().put("FinishTime", CommonInformationHelper.getString(fields, "FinishTime"));
            node.getFields().put("LocalPath", CommonInformationHelper.getString(fields, "ProjectFile"));
            node.getFields().put("ServerPath", CommonInformationHelper.getString(fields, "ProjectFile"));
            node.getFields().put("StartTime", CommonInformationHelper.getString(fields, "StartTime"));
            node.getFields().put("StaticAnalysisErrors", CommonInformationHelper.getString(fields, "StaticAnalysisErrors"));
            node.getFields().put("StaticAnalysisWarnings", CommonInformationHelper.getString(fields, "StaticAnalysisWarnings"));
            node.getFields().put("TargetNames", "");
            node.getFields().put("Flavor", CommonInformationHelper.getString(compilationSummaryNode.getParent().getFields(), "Flavor"));
            node.getFields().put("Platform", CommonInformationHelper.getString(compilationSummaryNode.getParent().getFields(), "Platform"));
            if (this.getLogLocation() == null) continue;
            IBuildInformationNode logFileNode = node.getChildren().createNode();
            logFileNode.setType("ExternalLink");
            logFileNode.getFields().put("DisplayText", Messages.getString("BuildDetail2012.BuildLogFileLink"));
            logFileNode.getFields().put("Url", this.getLogLocation());
        }
    }

    @Override
    public String getBuildControllerURI() {
        return this.getWebServiceObject().getBuildControllerUri();
    }

    public void setBuildContrllerURI(String value) {
        this.getWebServiceObject().setBuildControllerUri(value);
    }

    @Override
    public String getBuildDefinitionURI() {
        return this.getWebServiceObject().getBuildDefinitionUri();
    }

    public void setBuildDefinitionUri(String value) {
        this.getWebServiceObject().setBuildDefinitionUri(value);
    }

    @Override
    public String getBuildNumber() {
        return this.getWebServiceObject().getBuildNumber();
    }

    @Override
    public void setBuildNumber(String value) {
        this.getWebServiceObject().setBuildNumber(value);
    }

    @Override
    public BuildPhaseStatus getCompilationStatus() {
        return BuildPhaseStatus.fromWebServiceObject(this.getWebServiceObject().getCompilationStatus());
    }

    @Override
    public void setCompilationStatus(BuildPhaseStatus value) {
        this.getWebServiceObject().setCompilationStatus(value.getWebServiceObject());
    }

    @Override
    public String getDropLocation() {
        return this.getWebServiceObject().getDropLocation();
    }

    @Override
    public void setDropLocation(String value) {
        this.getWebServiceObject().setDropLocation(value);
    }

    @Override
    public String getDropLocationRoot() {
        return this.getWebServiceObject().getDropLocationRoot();
    }

    @Override
    public Calendar getFinishTime() {
        return this.getWebServiceObject().getFinishTime();
    }

    public BuildInformationNode[] getInternalInformation() {
        return (BuildInformationNode[])WrapperUtils.wrap(BuildInformationNode.class, this.getWebServiceObject().getInformation());
    }

    public void setInternalInformation(BuildInformationNode[] value) {
        this.getWebServiceObject().setInformation((_BuildInformationNode[])WrapperUtils.unwrap(_BuildInformationNode.class, value));
    }

    @Override
    public boolean isIsDeleted() {
        return this.getWebServiceObject().isIsDeleted();
    }

    @Override
    public boolean isKeepForever() {
        return this.getWebServiceObject().isKeepForever();
    }

    @Override
    public void setKeepForever(boolean value) {
        this.getWebServiceObject().setKeepForever(value);
    }

    @Override
    public String getLabelName() {
        return this.getWebServiceObject().getLabelName();
    }

    @Override
    public void setLabelName(String value) {
        this.getWebServiceObject().setLabelName(value);
    }

    @Override
    public String getLastChangedBy() {
        return this.getWebServiceObject().getLastChangedBy();
    }

    @Override
    public String getLastChangedByDisplayName() {
        return this.getWebServiceObject().getLastChangedByDisplayName();
    }

    @Override
    public Calendar getLastChangedOn() {
        return this.getWebServiceObject().getLastChangedOn();
    }

    @Override
    public String getLogLocation() {
        return this.getWebServiceObject().getLogLocation();
    }

    @Override
    public void setLogLocation(String value) {
        this.getWebServiceObject().setLogLocation(value);
    }

    @Override
    public String getProcessParameters() {
        return this.getWebServiceObject().getProcessParameters();
    }

    @Override
    public String getQuality() {
        return this.getWebServiceObject().getQuality();
    }

    @Override
    public void setQuality(String value) {
        this.getWebServiceObject().setQuality(value);
    }

    @Override
    public BuildReason getReason() {
        return BuildReason.fromWebServiceObject(this.getWebServiceObject().getReason());
    }

    @Override
    public String getSourceGetVersion() {
        return this.getWebServiceObject().getSourceGetVersion();
    }

    public void setSourceGetVersion(String value) {
        this.getWebServiceObject().setSourceGetVersion(value);
    }

    @Override
    public Calendar getStartTime() {
        return this.getWebServiceObject().getStartTime();
    }

    @Override
    public BuildStatus getStatus() {
        return BuildStatus.fromWebServiceObject(this.getWebServiceObject().getStatus());
    }

    @Override
    public void setStatus(BuildStatus value) {
        this.getWebServiceObject().setStatus(value.getWebServiceObject());
    }

    @Override
    public String getTeamProject() {
        return this.getWebServiceObject().getTeamProject();
    }

    @Override
    public BuildPhaseStatus getTestStatus() {
        return BuildPhaseStatus.fromWebServiceObject(this.getWebServiceObject().getTestStatus());
    }

    @Override
    public void setTestStatus(BuildPhaseStatus value) {
        this.getWebServiceObject().setTestStatus(value.getWebServiceObject());
    }

    @Override
    public String getURI() {
        return this.getWebServiceObject().getUri();
    }

    public BuildServer getInternalBuildServer() {
        return this.buildServer;
    }

    @Override
    public IBuildServer getBuildServer() {
        return this.buildServer;
    }

    public void setBuildServer(IBuildServer value) {
        this.buildServer = (BuildServer)value;
    }

    @Override
    public IBuildController getBuildController() {
        return this.buildController;
    }

    public void setBuildController(IBuildController value) {
        this.buildController = value;
    }

    @Override
    public IBuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    public void setBuildDefinition(IBuildDefinition value) {
        this.buildDefinition = (BuildDefinition)value;
        if (this.buildDefinition == null) {
            this.getWebServiceObject().setBuildDefinitionUri(null);
        } else {
            this.getWebServiceObject().setBuildDefinitionUri(this.buildDefinition.getURI());
            if (StringUtil.isNullOrEmpty(this.getWebServiceObject().getTeamProject())) {
                this.getWebServiceObject().setTeamProject(this.buildDefinition.getTeamProject());
            }
        }
    }

    @Override
    public boolean isBuildFinished() {
        return this.getFinishTime().after(DotNETDate.MIN_CALENDAR);
    }

    @Override
    public IBuildInformation getInformation() {
        return this.informationNodes;
    }

    public void setInformation(IBuildInformation value) {
        this.informationNodes = value;
    }

    @Override
    public int[] getRequestIDs() {
        return this.requestIds;
    }

    @Override
    public IQueuedBuild[] getRequests() {
        return this.requests;
    }

    public void addRequest(IQueuedBuild newRequest) {
        if (this.requestIds.length == 1 && this.requestIds[0] == 0) {
            this.requestIds = new int[0];
            this.requests = new IQueuedBuild[0];
        }
        IQueuedBuild[] newRequests = new IQueuedBuild[this.requests.length + 1];
        for (int i = 0; i < this.requests.length; ++i) {
            newRequests[i] = this.requests[i];
        }
        newRequests[this.requests.length] = newRequest;
        this.requests = newRequests;
    }

    @Override
    public String getRequestedBy() {
        if (this.requests.length == 1) {
            return this.requests[0].getRequestedByDisplayName();
        }
        if (this.requests.length > 1) {
            String[] names = this.getDistinctRequestedByDisplayNames();
            return names.length > 1 ? Messages.getString("BuildDetail2012.MultiplePlaceHolder") : names[0];
        }
        if (this.buildServer.getBuildServerVersion().isLessThanV4()) {
            return this.requestedBy;
        }
        return null;
    }

    @Override
    public String getRequestedFor() {
        if (this.requests.length == 1) {
            return this.requests[0].getRequestedForDisplayName();
        }
        if (this.requests.length > 1) {
            String[] names = this.getDistinctRequestedForDisplayNames();
            return names.length > 1 ? Messages.getString("BuildDetail2012.MultiplePlaceHolder") : names[0];
        }
        if (this.buildServer.getBuildServerVersion().isLessThanV4()) {
            return this.requestedFor;
        }
        return null;
    }

    @Override
    public String getShelvesetName() {
        if (this.requests.length == 1) {
            return this.requests[0].getShelvesetName();
        }
        if (this.requests.length > 1) {
            return Messages.getString("BuildDetail2012.MultiplePlaceHolder");
        }
        if (this.buildServer.getBuildServerVersion().isLessThanV4()) {
            return this.shelvesetName;
        }
        return null;
    }

    public void setShelvesetName(String value) {
        this.shelvesetName = value;
    }

    @Override
    public IBuildDeletionResult delete() {
        return this.delete(DeleteOptions.ALL);
    }

    @Override
    public IBuildDeletionResult delete(DeleteOptions options) {
        if (this.buildServer.getBuildServerVersion().isLessThanV3() && !options.equals(DeleteOptions.ALL)) {
            String format = Messages.getString("BuildDetail2012.DeleteOptionsNotSupportedFormat");
            String message = MessageFormat.format(format, options.toString());
            throw new NotSupportedException(message);
        }
        return this.buildServer.deleteBuilds(new String[]{this.getURI()}, options)[0];
    }

    public void finalizeStatus() {
        if (!(this.getStatus().equals(BuildStatus.FAILED) || this.getStatus().equals(BuildStatus.PARTIALLY_SUCCEEDED) || this.getStatus().equals(BuildStatus.STOPPED) || this.getStatus().equals(BuildStatus.SUCCEEDED))) {
            throw new InvalidFinalStatusException(this.getBuildNumber(), this.getStatus(), this.getBuildServer());
        }
        this.save();
        if (this.buildServer.getBuildServerVersion().isV3OrGreater()) {
            BuildDetail build = this.buildServer.getBuildServerVersion().isV3() ? this.buildServer.getBuild2010Helper().notifyBuildCompleted(this.getURI()) : this.buildServer.getBuildService().notifyBuildCompleted(this.getURI());
            this.copy(build, null, QueryOptions.NONE);
        }
    }

    @Override
    public void refresh(String[] informationTypes, QueryOptions queryOptions) {
        if (this.getURI() != null) {
            this.copy(this.buildServer.getBuild(this.getURI(), informationTypes, queryOptions, QueryDeletedOption.INCLUDE_DELETED), informationTypes, queryOptions);
        }
    }

    @Override
    public GUID requestIntermediateLogs() {
        if (this.buildServer.getBuildServerVersion().isLessThanV4()) {
            String format = Messages.getString("BuildDetail2012.MethodNotSupportedFormat");
            String message = MessageFormat.format(format, "RequestIntermediateLogs", "IBuildDetail");
            throw new NotSupportedException(message);
        }
        return this.buildServer.getBuildService().requestIntermediateLogs(this.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(IBuildDetail build, String[] informationTypes, QueryOptions queryOptions) {
        BuildUpdateOptions buildUpdateOptions = this.lastSnapshot;
        synchronized (buildUpdateOptions) {
            this.setBuildNumber(build.getBuildNumber());
            this.setCompilationStatus(build.getCompilationStatus());
            this.setDropLocation(build.getDropLocation());
            this.setLabelName(build.getLabelName());
            this.setLogLocation(build.getLogLocation());
            this.setKeepForever(build.isKeepForever());
            this.setQuality(build.getQuality());
            this.setSourceGetVersion(build.getSourceGetVersion());
            this.setStatus(build.getStatus());
            this.setTestStatus(build.getTestStatus());
            this.getWebServiceObject().setLastChangedBy(build.getLastChangedBy());
            this.getWebServiceObject().setLastChangedOn(build.getLastChangedOn());
            this.getWebServiceObject().setStartTime(build.getStartTime());
            this.getWebServiceObject().setFinishTime(build.getFinishTime());
            if (queryOptions.contains(QueryOptions.BATCHED_REQUESTS)) {
                this.requestIds = ((BuildDetail)build).getRequestIDs();
                this.requests = build.getRequests();
            }
            if (queryOptions.contains(QueryOptions.DEFINITIONS)) {
                this.setBuildDefinition(build.getBuildDefinition());
            }
            if (informationTypes != null) {
                this.setInformation(build.getInformation());
                this.setBuildInformation(this.getInformation());
            }
            this.lastSnapshot = this.getSnapshot();
        }
    }

    private void setBuildInformation(IBuildInformation information) {
        for (IBuildInformationNode node : information.getNodes()) {
            ((BuildInformationNode)node).setBuild(this);
            this.setBuildInformation(node.getChildren());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        BuildUpdateOptions buildUpdateOptions = this.lastSnapshot;
        synchronized (buildUpdateOptions) {
            BuildUpdateOptions currentSnapshot = this.getSnapshot();
            currentSnapshot.setFields(this.compareSnapshots(this.lastSnapshot, currentSnapshot));
            if (!currentSnapshot.getFields().equals(BuildUpdate.NONE)) {
                BuildDetail build = null;
                build = this.buildServer.getBuildServerVersion().isV2() ? this.buildServer.getBuild2008Helper().updateBuilds(new BuildUpdateOptions[]{currentSnapshot})[0] : (this.buildServer.getBuildServerVersion().isV3() ? this.buildServer.getBuild2010Helper().updateBuilds(new BuildUpdateOptions[]{currentSnapshot})[0] : this.buildServer.getBuildService().updateBuilds(new BuildUpdateOptions[]{currentSnapshot})[0]);
                if (build != null && this.isDirty(currentSnapshot, BuildUpdate.STATUS)) {
                    this.copy(build, null, QueryOptions.NONE);
                }
            }
            this.lastSnapshot = currentSnapshot;
        }
    }

    @Override
    public void stop() {
        this.buildServer.stopBuilds(new String[]{this.getURI()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildUpdateOptions getUpdateOptions() {
        BuildUpdateOptions currentSnapshot;
        BuildUpdateOptions buildUpdateOptions = this.lastSnapshot;
        synchronized (buildUpdateOptions) {
            currentSnapshot = this.getSnapshot();
            currentSnapshot.setFields(this.compareSnapshots(this.lastSnapshot, currentSnapshot));
        }
        return currentSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateOptions(BuildUpdateOptions snapshot) {
        BuildUpdateOptions buildUpdateOptions = this.lastSnapshot;
        synchronized (buildUpdateOptions) {
            this.lastSnapshot = snapshot;
        }
    }

    private BuildUpdateOptions getSnapshot() {
        BuildUpdateOptions result = new BuildUpdateOptions();
        result.setBuildNumber(this.getBuildNumber());
        result.setCompilationStatus(this.getCompilationStatus());
        result.setDropLocation(this.getDropLocation());
        result.setKeepForever(this.isKeepForever());
        result.setLabelName(this.getLabelName());
        result.setLogLocation(this.getLogLocation());
        result.setQuality(this.getQuality());
        result.setSourceGetVersion(this.getSourceGetVersion());
        result.setStatus(this.getStatus());
        result.setTestStatus(this.getTestStatus());
        result.setURI(this.getURI());
        return result;
    }

    private BuildUpdate compareSnapshots(BuildUpdateOptions originalValues, BuildUpdateOptions modifiedValues) {
        BuildUpdate result = new BuildUpdate();
        if (!BuildDetail.equalsIgnoreCase(originalValues.getBuildNumber(), modifiedValues.getBuildNumber())) {
            result.add(BuildUpdate.BUILD_NUMBER);
        }
        if (!originalValues.getCompilationStatus().equals(modifiedValues.getCompilationStatus())) {
            result.add(BuildUpdate.COMPILATION_STATUS);
        }
        if (!BuildDetail.equalsIgnoreCase(originalValues.getDropLocation(), modifiedValues.getDropLocation())) {
            result.add(BuildUpdate.DROP_LOCATION);
        }
        if (originalValues.isKeepForever() != modifiedValues.isKeepForever()) {
            result.add(BuildUpdate.KEEP_FOREVER);
        }
        if (!BuildDetail.equalsIgnoreCase(originalValues.getLabelName(), modifiedValues.getLabelName())) {
            result.add(BuildUpdate.LABEL_NAME);
        }
        if (!BuildDetail.equalsIgnoreCase(originalValues.getLogLocation(), modifiedValues.getLogLocation())) {
            result.add(BuildUpdate.LOG_LOCATION);
        }
        if (!BuildDetail.equalsIgnoreCase(originalValues.getQuality(), modifiedValues.getQuality())) {
            result.add(BuildUpdate.QUALITY);
        }
        if (!BuildDetail.equalsIgnoreCase(originalValues.getSourceGetVersion(), modifiedValues.getSourceGetVersion())) {
            result.add(BuildUpdate.SOURCE_GET_VERSION);
        }
        if (!originalValues.getStatus().equals(modifiedValues.getStatus())) {
            result.add(BuildUpdate.STATUS);
        }
        if (!originalValues.getTestStatus().equals(modifiedValues.getTestStatus())) {
            result.add(BuildUpdate.TEST_STATUS);
        }
        return result;
    }

    private static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equalsIgnoreCase(s2);
    }

    private boolean isDirty(BuildUpdateOptions snapshot, BuildUpdate.Field dirtyFlag) {
        return snapshot.getFields().contains(dirtyFlag);
    }

    private String[] getDistinctRequestedByDisplayNames() {
        HashSet<String> set = new HashSet<String>();
        for (IQueuedBuild request : this.requests) {
            if (set.contains(request.getRequestedByDisplayName())) continue;
            set.add(request.getRequestedForDisplayName());
        }
        return set.toArray(new String[set.size()]);
    }

    private String[] getDistinctRequestedForDisplayNames() {
        HashSet<String> set = new HashSet<String>();
        for (IQueuedBuild request : this.requests) {
            if (set.contains(request.getRequestedForDisplayName())) continue;
            set.add(request.getRequestedForDisplayName());
        }
        return set.toArray(new String[set.size()]);
    }
}

