/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IProcessTemplate;
import com.microsoft.tfs.core.clients.build.flags.BuildReason;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.ProcessTemplate2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.clients.build.soapextensions.ProcessTemplateType;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.Check;
import ms.tfs.build.buildservice._04._ProcessTemplate;

public class ProcessTemplate
extends WebServiceObjectWrapper
implements IProcessTemplate {
    private IBuildServer buildServer;

    public ProcessTemplate(IBuildServer buildServer) {
        this(buildServer, new _ProcessTemplate());
    }

    public ProcessTemplate(IBuildServer buildServer, _ProcessTemplate webServiceObject) {
        super(webServiceObject);
    }

    public ProcessTemplate(IBuildServer buildServer, String teamProject, String serverPath) {
        this(buildServer);
        this.buildServer = buildServer;
        this.getWebServiceObject().setTeamProject(teamProject);
        this.getWebServiceObject().setServerPath(serverPath);
    }

    public ProcessTemplate(IBuildServer buildServer, ProcessTemplate2010 template2010) {
        this(buildServer);
        _ProcessTemplate template = this.getWebServiceObject();
        this.buildServer = template2010.getBuildServer();
        template.setDescription(template2010.getDescription());
        template.setFileExists(template2010.isFileExists());
        template.setId(template2010.getID());
        template.setParameters(template2010.getParameters());
        template.setServerPath(template2010.getServerPath());
        template.setSupportedReasons(TFS2010Helper.convert(template2010.getSupportedReasons()).getWebServiceObject());
        template.setTeamProject(template2010.getTeamProject());
        template.setTemplateType(TFS2010Helper.convert(template2010.getTemplateType()).getWebServiceObject());
    }

    public _ProcessTemplate getWebServiceObject() {
        return (_ProcessTemplate)this.webServiceObject;
    }

    @Override
    public String getDescription() {
        return this.getWebServiceObject().getDescription();
    }

    @Override
    public void setDescription(String value) {
        this.getWebServiceObject().setDescription(value);
    }

    @Override
    public String getServerPath() {
        return this.getWebServiceObject().getServerPath();
    }

    @Override
    public BuildReason getSupportedReasons() {
        return BuildReason.fromWebServiceObject(this.getWebServiceObject().getSupportedReasons());
    }

    @Override
    public void setSupportedReasons(BuildReason value) {
        this.getWebServiceObject().setSupportedReasons(value.getWebServiceObject());
    }

    @Override
    public String getTeamProject() {
        return this.getWebServiceObject().getTeamProject();
    }

    @Override
    public ProcessTemplateType getTemplateType() {
        return ProcessTemplateType.fromWebServiceObject(this.getWebServiceObject().getTemplateType());
    }

    @Override
    public void setTemplateType(ProcessTemplateType value) {
        this.getWebServiceObject().setTemplateType(value.getWebServiceObject());
    }

    public boolean isFileExists() {
        return this.getWebServiceObject().isFileExists();
    }

    @Override
    public int getID() {
        return this.getWebServiceObject().getId();
    }

    public void setID(int value) {
        this.getWebServiceObject().setId(value);
    }

    @Override
    public String getParameters() {
        return this.getWebServiceObject().getParameters();
    }

    public void setParameters(String value) {
        this.getWebServiceObject().setParameters(value);
    }

    @Override
    public String getVersion() {
        return this.getWebServiceObject().getVersion();
    }

    public IBuildServer getBuildServer() {
        return this.buildServer;
    }

    @Override
    public String download() {
        return this.download(null);
    }

    @Override
    public String download(String sourceGetVersion) {
        throw new NotSupportedException();
    }

    @Override
    public void save() {
        this.buildServer.saveProcessTemplates(new IProcessTemplate[]{this});
    }

    @Override
    public void delete() {
        this.buildServer.deleteProcessTemplates(new IProcessTemplate[]{this});
        this.getWebServiceObject().setId(-1);
    }

    @Override
    public void copyFrom(IProcessTemplate processTemplate) {
        Check.notNull(processTemplate, "processTemplate");
        ProcessTemplate source = (ProcessTemplate)processTemplate;
        _ProcessTemplate template = this.getWebServiceObject();
        template.setDescription(source.getDescription());
        template.setFileExists(source.isFileExists());
        template.setId(source.getID());
        template.setParameters(source.getParameters());
        template.setServerPath(source.getServerPath());
        template.setSupportedReasons(source.getSupportedReasons().getWebServiceObject());
        template.setTeamProject(source.getTeamProject());
        template.setTemplateType(source.getTemplateType().getWebServiceObject());
    }

    public void prepareToSave() {
    }
}

