/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.Check;
import java.net.URI;
import java.text.MessageFormat;

public class WorkspaceKey {
    private final URI serverURI;
    private final String workspaceName;
    private final String ownerName;

    public WorkspaceKey(Workspace workspace) {
        Check.notNull(workspace, "workspace");
        this.serverURI = URIUtils.removeTrailingSlash(workspace.getServerURI());
        this.workspaceName = workspace.getName();
        this.ownerName = workspace.getOwnerName();
    }

    public WorkspaceKey(WorkspaceInfo cachedWorkspace) {
        Check.notNull(cachedWorkspace, "cachedWorkspace");
        this.serverURI = URIUtils.removeTrailingSlash(cachedWorkspace.getServerURI());
        this.workspaceName = cachedWorkspace.getName();
        this.ownerName = cachedWorkspace.getOwnerName();
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String toString() {
        return MessageFormat.format("WorkspaceKey: workspaceName=[{0}], server=[{1}]", this.workspaceName, this.serverURI.toString());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkspaceKey other = (WorkspaceKey)obj;
        return this.serverURI.equals(other.serverURI) && this.workspaceName.equalsIgnoreCase(other.workspaceName);
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.serverURI.hashCode();
        hash = 37 * hash + this.workspaceName.toLowerCase().hashCode();
        hash = 37 * hash + this.ownerName.toLowerCase().hashCode();
        return hash;
    }
}

