/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictCategory;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescriptionStrings;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.DeletedConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.CoreConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.contributors.ConflictResolutionContributor;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import java.util.ArrayList;

public class ServerDeletedConflictDescription
extends DeletedConflictDescription {
    protected ServerDeletedConflictDescription(Workspace workspace, Conflict conflict, ItemSpec[] conflictItemSpecs) {
        super(workspace, conflict, conflictItemSpecs);
    }

    @Override
    public ConflictCategory getConflictCategory() {
        return ConflictCategory.SERVER_DELETED;
    }

    @Override
    public String getDescription() {
        Conflict conflict = this.getConflict();
        if (conflict != null && conflict.getTheirChangeType().contains(ChangeType.SOURCE_RENAME)) {
            return Messages.getString("ServerDeletedConflictDescription.DescriptionRenamedOnServer");
        }
        return Messages.getString("ServerDeletedConflictDescription.DescriptionAlreadyDeleted");
    }

    @Override
    public ConflictResolution[] getResolutions(ConflictResolutionContributor resolutionContributor) {
        ArrayList<CoreConflictResolution> resolutionList = new ArrayList<CoreConflictResolution>();
        resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.VERSION_ACCEPT_THEIRS, ConflictDescriptionStrings.VERSION_ACCEPT_THEIRS_TOOLTIP, ConflictResolutionOptions.NONE, Resolution.ACCEPT_THEIRS));
        resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.VERSION_DELETED_ACCEPT_YOURS, ConflictDescriptionStrings.VERSION_DELETED_ACCEPT_YOURS_TOOLTIP, ConflictResolutionOptions.NONE, Resolution.ACCEPT_YOURS));
        return resolutionList.toArray(new ConflictResolution[resolutionList.size()]);
    }
}

