/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.CheckinNoteNameValidationException;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNoteFieldValue;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import ms.tfs.versioncontrol.clientservices._03._CheckinNote;
import ms.tfs.versioncontrol.clientservices._03._CheckinNoteFieldValue;
import org.w3c.dom.Element;

public class CheckinNote
extends WebServiceObjectWrapper {
    public static final String XML_CHECKIN_NOTES = "CheckinNotes";
    public static final String XML_NOTE = "Note";
    public static final String XML_NOTE_NAME = "name";
    public static final int CHECKIN_NOTE_NAME_MAX_SIZE_CHARS = 64;

    public CheckinNote() {
        super(new _CheckinNote());
    }

    public CheckinNote(_CheckinNote checkinNote) {
        super(checkinNote);
    }

    public CheckinNote(CheckinNoteFieldValue[] values) {
        super(new _CheckinNote(CheckinNote.toWebServiceObjectArray(values)));
    }

    public _CheckinNote getWebServiceObject() {
        return (_CheckinNote)this.webServiceObject;
    }

    private static _CheckinNoteFieldValue[] toWebServiceObjectArray(CheckinNoteFieldValue[] values) {
        Check.notNull(values, "values");
        _CheckinNoteFieldValue[] ret = new _CheckinNoteFieldValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = values[i].getWebServiceObject();
        }
        return ret;
    }

    public static String canonicalizeName(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.length() == 0) {
            throw new CheckinNoteNameValidationException(Messages.getString("CheckinNote.SuppliedCheckinNoteNameWasEmpty"));
        }
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isISOControl(name.charAt(i))) continue;
            throw new CheckinNoteNameValidationException(Messages.getString("CheckinNote.SuppliedCheckinNoteNameContainedAnIllegalCharacter"), name);
        }
        if (name.length() > 64) {
            throw new CheckinNoteNameValidationException(MessageFormat.format(Messages.getString("CheckinNote.SuppliedCheckinNoteNameTooLongMaximumSizeFormat"), 64), name);
        }
        return name;
    }

    public CheckinNoteFieldValue[] getValues() {
        _CheckinNote note = this.getWebServiceObject();
        if (note == null || note.getValues() == null || note.getValues().length == 0) {
            return new CheckinNoteFieldValue[0];
        }
        _CheckinNoteFieldValue[] values = note.getValues();
        CheckinNoteFieldValue[] ret = new CheckinNoteFieldValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = new CheckinNoteFieldValue(values[i]);
        }
        return ret;
    }

    public synchronized Iterator iterator() {
        return Arrays.asList(this.getWebServiceObject().getValues()).iterator();
    }

    public static CheckinNote loadFromXML(Element checkinNoteNode) {
        ArrayList<CheckinNoteFieldValue> fieldValues = new ArrayList<CheckinNoteFieldValue>();
        for (Element child : DOMUtils.getChildElements(checkinNoteNode)) {
            if (!child.getNodeName().equals(XML_NOTE)) continue;
            String fieldName = child.getAttributes().getNamedItem(XML_NOTE_NAME).getNodeValue();
            String fieldValue = DOMUtils.getText(child);
            fieldValues.add(new CheckinNoteFieldValue(fieldName, fieldValue));
        }
        return new CheckinNote(fieldValues.toArray(new CheckinNoteFieldValue[fieldValues.size()]));
    }

    public synchronized void saveAsXML(Element parent) {
        Element checkinNoteNode = DOMUtils.appendChild(parent, XML_CHECKIN_NOTES);
        for (CheckinNoteFieldValue fieldValue : this.getValues()) {
            Element noteNode = DOMUtils.appendChildWithText(checkinNoteNode, XML_NOTE, fieldValue.getValue());
            noteNode.setAttribute(XML_NOTE_NAME, fieldValue.getName());
        }
    }
}

