/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.specs;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.specs.LabelSpecParseException;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import java.text.MessageFormat;

public final class LabelSpec {
    private static final String LABEL_AND_SCOPE_SEPARATOR = "@";
    private final String label;
    private final String scope;

    public LabelSpec(String label, String scope) {
        Check.notNullOrEmpty(label, "label");
        this.label = label;
        this.scope = scope;
    }

    public static LabelSpec parse(String specString, String defaultScope, boolean permitWildcardsInLabel) throws LabelSpecParseException {
        String scope;
        String label;
        Check.notNullOrEmpty(specString, "specString");
        int index = specString.indexOf(LABEL_AND_SCOPE_SEPARATOR);
        if (index < 0) {
            label = specString;
            scope = defaultScope;
        } else {
            if (index == 0) {
                throw new LabelSpecParseException(Messages.getString("LabelSpec.LabelSpecMustIncludeName"));
            }
            label = specString.substring(0, index);
            scope = index + 1 == specString.length() ? defaultScope : specString.substring(index + 1);
        }
        if (!LabelSpec.isValidLabelName(label, permitWildcardsInLabel)) {
            if (permitWildcardsInLabel) {
                throw new LabelSpecParseException(MessageFormat.format(Messages.getString("LabelSpec.LabelNameIsNotValidMayContainWildcardsFormat"), label));
            }
            throw new LabelSpecParseException(MessageFormat.format(Messages.getString("LabelSpec.LabelNameIsNotValidMayNotContainWildcardsFormat"), label));
        }
        if (scope != null && !LabelSpec.isValidScope(scope)) {
            if (ServerPath.isWildcard(scope)) {
                throw new LabelSpecParseException(Messages.getString("LabelSpec.WildcardsAreNotAllowedInLabelScopes"));
            }
            throw new LabelSpecParseException(MessageFormat.format(Messages.getString("LabelSpec.LabelScopeIsNotValidFormat"), scope));
        }
        return new LabelSpec(label, scope);
    }

    private static boolean isValidScope(String scope) {
        return scope == null || ServerPath.isServerPath(scope) && !ServerPath.isWildcard(scope);
    }

    private static boolean isValidLabelName(String labelName, boolean permitWildcards) {
        if (labelName == null) {
            return false;
        }
        if (labelName.length() > 64) {
            return false;
        }
        if (labelName.indexOf(LABEL_AND_SCOPE_SEPARATOR) != -1) {
            return false;
        }
        return FileHelpers.isValidNTFSFileName(labelName, permitWildcards);
    }

    public synchronized String toString() {
        return this.label + LABEL_AND_SCOPE_SEPARATOR + this.scope;
    }

    public String getLabel() {
        return this.label;
    }

    public String getScope() {
        return this.scope;
    }
}

