/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.workspacecache;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkItemCheckinInfo;
import com.microsoft.tfs.core.clients.workitem.CheckinWorkItemAction;
import com.microsoft.tfs.core.ws.runtime.xml.XMLConvert;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WorkItemCheckedInfo
implements Cloneable {
    private static final Log log = LogFactory.getLog(WorkItemCheckedInfo.class);
    public static final String XML_TAG_WORK_ITEM_CHECKED_INFO = "WorkItemsCheckedInfo";
    private static final String XML_TAG_WORK_ITEM = "WorkItem";
    private static final String XML_TAG_ATTRID = "Id";
    private static final String XML_TAG_ATTR_CHECKED = "Checked";
    private static final String XML_TAG_ATTR_ACTION = "Action";
    private final int id;
    private final boolean checked;
    private final CheckinWorkItemAction action;

    public WorkItemCheckedInfo(int id, boolean checkedOnOff, CheckinWorkItemAction action) {
        this.id = id;
        this.checked = checkedOnOff;
        this.action = action;
    }

    public static WorkItemCheckedInfo[] fromCheckinInfo(WorkItemCheckinInfo[] checkinInfo) {
        if (checkinInfo == null) {
            return new WorkItemCheckedInfo[0];
        }
        WorkItemCheckedInfo[] checkedInfo = new WorkItemCheckedInfo[checkinInfo.length];
        for (int i = 0; i < checkedInfo.length; ++i) {
            Check.notNull(checkinInfo[i], "checkinInfo[i]");
            checkedInfo[i] = new WorkItemCheckedInfo(checkinInfo[i].getWorkItem().getID(), true, checkinInfo[i].getAction());
        }
        return checkedInfo;
    }

    public static WorkItemCheckedInfo[] loadFromXML(Document doc) {
        Element element = DOMUtils.getFirstChildElement(doc, XML_TAG_WORK_ITEM_CHECKED_INFO);
        if (element == null) {
            return null;
        }
        return WorkItemCheckedInfo.loadFromXML(element);
    }

    public static WorkItemCheckedInfo[] loadFromXML(Element listRoot) {
        Element[] childNodes = DOMUtils.getChildElements(listRoot);
        if (childNodes.length == 0) {
            return null;
        }
        ArrayList<WorkItemCheckedInfo> list = new ArrayList<WorkItemCheckedInfo>(childNodes.length);
        for (Element node : childNodes) {
            int id = 0;
            if (node.getAttributes().getNamedItem(XML_TAG_ATTRID) != null) {
                try {
                    id = Integer.parseInt(node.getAttributes().getNamedItem(XML_TAG_ATTRID).getNodeValue());
                }
                catch (NumberFormatException e) {
                    log.warn((Object)MessageFormat.format("Error parsing work item ID {0}, ignoring", node.getAttributes().getNamedItem(XML_TAG_ATTRID).getNodeValue()), (Throwable)e);
                    continue;
                }
            }
            boolean checkedOnOff = false;
            if (node.getAttributes().getNamedItem(XML_TAG_ATTR_CHECKED) != null) {
                checkedOnOff = "1".equals(node.getAttributes().getNamedItem(XML_TAG_ATTR_CHECKED).getNodeValue());
            }
            CheckinWorkItemAction action = CheckinWorkItemAction.NONE;
            if (node.getAttributes().getNamedItem(XML_TAG_ATTR_ACTION) != null) {
                action = WorkItemCheckedInfo.actionFromString(node.getAttributes().getNamedItem(XML_TAG_ATTR_ACTION).getNodeValue());
            }
            list.add(new WorkItemCheckedInfo(id, checkedOnOff, action));
        }
        return list.toArray(new WorkItemCheckedInfo[list.size()]);
    }

    public static void saveAsXML(Element parentNode, WorkItemCheckedInfo[] list) {
        if (list == null || list.length == 0) {
            return;
        }
        Element listRoot = DOMUtils.appendChild(parentNode, XML_TAG_WORK_ITEM_CHECKED_INFO);
        for (WorkItemCheckedInfo checkedInfo : list) {
            Element itemNode = DOMUtils.appendChild(listRoot, XML_TAG_WORK_ITEM);
            itemNode.setAttribute(XML_TAG_ATTRID, XMLConvert.toString(checkedInfo.getID()));
            itemNode.setAttribute(XML_TAG_ATTR_CHECKED, checkedInfo.isChecked() ? "1" : "0");
            itemNode.setAttribute(XML_TAG_ATTR_ACTION, WorkItemCheckedInfo.actionToString(checkedInfo.getCheckinAction()));
        }
    }

    public WorkItemCheckedInfo clone() {
        return new WorkItemCheckedInfo(this.id, this.checked, this.action);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WorkItemCheckedInfo)) {
            return false;
        }
        WorkItemCheckedInfo other = (WorkItemCheckedInfo)obj;
        if (this.id != other.id) {
            return false;
        }
        return this.checked == other.checked;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.id;
        result = result * 37 + (this.checked ? 1 : 0);
        return result;
    }

    public int getID() {
        return this.id;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public CheckinWorkItemAction getCheckinAction() {
        return this.action;
    }

    private static CheckinWorkItemAction actionFromString(String action) {
        if ("Associate".compareToIgnoreCase(action) == 0) {
            return CheckinWorkItemAction.ASSOCIATE;
        }
        if ("Resolve".compareToIgnoreCase(action) == 0) {
            return CheckinWorkItemAction.RESOLVE;
        }
        return CheckinWorkItemAction.NONE;
    }

    private static String actionToString(CheckinWorkItemAction action) {
        if (action == CheckinWorkItemAction.RESOLVE) {
            return "Resolve";
        }
        if (action == CheckinWorkItemAction.ASSOCIATE) {
            return "Associate";
        }
        return "None";
    }
}

