/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal;

import com.microsoft.tfs.core.util.ServerURIComparator;
import com.microsoft.tfs.core.util.ServerURIUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.LocaleInvariantStringHelpers;
import java.net.URI;

public class InternalServerInfo {
    private URI uri;
    private final GUID guid;

    public InternalServerInfo(URI uri, GUID guid) {
        Check.notNull(uri, "uri");
        Check.notNull(guid, "guid");
        this.uri = uri;
        this.guid = guid;
    }

    public synchronized URI getURI() {
        return this.uri;
    }

    public synchronized void setURI(URI value) {
        Check.notNull(value, "value");
        this.uri = value;
    }

    public GUID getServerGUID() {
        return this.guid;
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InternalServerInfo)) {
            return false;
        }
        return ServerURIComparator.INSTANCE.compare(this.uri, ((InternalServerInfo)obj).uri) == 0 && this.guid.equals(((InternalServerInfo)obj).guid);
    }

    public synchronized int hashCode() {
        int result = 17;
        result = result * 37 + LocaleInvariantStringHelpers.caseInsensitiveHashCode(ServerURIUtils.normalizeURI(this.uri).toString());
        result = result * 37 + this.guid.hashCode();
        return result;
    }
}

