/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.webservices;

import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import ms.ws._FilteredIdentitiesList;

public class FilteredIdentitiesList {
    private boolean hasMoreItems;
    private TeamFoundationIdentity[] items;
    private int startingIndex;
    private int totalItems;

    public static FilteredIdentitiesList fromWebServiceObject(_FilteredIdentitiesList webServiceObject) {
        FilteredIdentitiesList ret = new FilteredIdentitiesList();
        ret.hasMoreItems = webServiceObject.isHasMoreItems();
        ret.items = (TeamFoundationIdentity[])WrapperUtils.wrap(TeamFoundationIdentity.class, webServiceObject.getItems());
        ret.startingIndex = webServiceObject.getStartingIndex();
        ret.totalItems = webServiceObject.getTotalItems();
        return ret;
    }

    public TeamFoundationIdentity[] getItems() {
        return this.items;
    }

    public void setItems(TeamFoundationIdentity[] items) {
        this.items = items;
    }

    public boolean getHasMoreItems() {
        return this.hasMoreItems;
    }

    public void setHasMoreItems(boolean hasMoreItems) {
        this.hasMoreItems = hasMoreItems;
    }

    public int getTotalItems() {
        if (this.hasMoreItems) {
            return this.totalItems;
        }
        return this.items.length;
    }

    public void setTotalItems(int totalItems) {
        this.totalItems = totalItems;
    }

    public int getStartingIndex() {
        return this.startingIndex;
    }

    public void setStartingIndex(int index) {
        this.startingIndex = index;
    }
}

