/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.metadata.dao;

import com.microsoft.tfs.core.internal.db.DBConnection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FieldDefinitionMetadata {
    private final int id;
    private final int type;
    private final String name;
    private final String referenceName;
    private final boolean supportsTextQuery;

    public static String getSelectStatement(DBConnection connection) {
        StringBuilder sb = new StringBuilder();
        sb.append("select FldID, Type, Name, ReferenceName");
        if (connection.getDBSpecificOperations().columnExists("Fields", "fSupportsTextQuery")) {
            sb.append(", fSupportsTextQuery");
        }
        sb.append(" from Fields");
        return sb.toString();
    }

    public static FieldDefinitionMetadata fromRow(ResultSet rset) throws SQLException {
        int id = rset.getInt(1);
        int type = rset.getInt(2);
        String name = rset.getString(3);
        String referenceName = rset.getString(4);
        boolean supportsTextQuery = rset.getMetaData().getColumnCount() > 4 ? rset.getBoolean(5) : false;
        return new FieldDefinitionMetadata(id, type, name, referenceName, supportsTextQuery);
    }

    public FieldDefinitionMetadata(int id, int type, String name, String referenceName, boolean supportsTextQuery) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.referenceName = referenceName;
        this.supportsTextQuery = supportsTextQuery;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public int getType() {
        return this.type;
    }

    public boolean supportsTextQuery() {
        return this.supportsTextQuery;
    }
}

