/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.metadata.dao;

import com.microsoft.tfs.core.internal.db.DBConnection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FieldUsageMetadata {
    private final int fieldId;
    private final boolean core;
    private final boolean oftenQueried;
    private final boolean supportsTextQuery;

    public static String getSelectStatement(DBConnection connection) {
        StringBuilder sb = new StringBuilder();
        sb.append("select FldID, fCore, fOftenQueried");
        if (connection.getDBSpecificOperations().columnExists("FieldUsages", "fSupportsTextQuery")) {
            sb.append(", fSupportsTextQuery");
        }
        sb.append(" from FieldUsages");
        return sb.toString();
    }

    public static FieldUsageMetadata fromRow(ResultSet rset) throws SQLException {
        int fieldId = rset.getInt(1);
        boolean core = rset.getBoolean(2);
        boolean oftenQueried = rset.getBoolean(3);
        boolean supportsTextQuery = rset.getMetaData().getColumnCount() > 3 ? rset.getBoolean(4) : false;
        return new FieldUsageMetadata(fieldId, core, oftenQueried, supportsTextQuery);
    }

    public FieldUsageMetadata(int fieldId, boolean core, boolean oftenQueried, boolean supportsTextQuery) {
        this.fieldId = fieldId;
        this.core = core;
        this.oftenQueried = oftenQueried;
        this.supportsTextQuery = supportsTextQuery;
    }

    public boolean isCore() {
        return this.core;
    }

    public int getFieldID() {
        return this.fieldId;
    }

    public boolean isOftenQueried() {
        return this.oftenQueried;
    }

    public boolean supportsTextQuery() {
        return this.supportsTextQuery;
    }
}

