/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.workitem.exceptions.WorkItemException;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryDefinitionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryFolderAction;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryItemImpl;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryDefinition;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryFolder;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryHierarchy;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryItem;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryItemType;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class QueryFolderImpl
extends QueryItemImpl
implements QueryFolder {
    private final Object lock = new Object();
    private final List<QueryItem> items = new ArrayList<QueryItem>();
    private List<QueryItem> addedItems;
    private List<QueryItem> removedItems;
    private boolean needsSort;

    public QueryFolderImpl(String name) {
        super(name, null);
    }

    public QueryFolderImpl(String name, QueryFolder parent) {
        super(name, parent);
    }

    protected QueryFolderImpl(String name, QueryFolder parent, GUID id, IdentityDescriptor ownerDescriptor) {
        super(name, parent, id, ownerDescriptor);
    }

    @Override
    public QueryFolder newFolder(String name) {
        return new QueryFolderImpl(name, this);
    }

    @Override
    public QueryDefinition newDefinition(String name, String queryText) {
        return new QueryDefinitionImpl(name, queryText, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryItem[] getItems() {
        Object object = this.lock;
        synchronized (object) {
            if (this.needsSort) {
                Collections.sort(this.items, new QueryItemComparator());
                this.needsSort = false;
            }
        }
        return this.items.toArray(new QueryItem[this.items.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(QueryItem item) {
        Check.notNull(item, "item");
        Object object = this.lock;
        synchronized (object) {
            Iterator<QueryItem> i = this.items.iterator();
            while (i.hasNext()) {
                if (!item.equals(i.next())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsID(GUID id) {
        Check.notNull(id, "id");
        Object object = this.lock;
        synchronized (object) {
            Iterator<QueryItem> i = this.items.iterator();
            while (i.hasNext()) {
                if (!id.equals(i.next().getID())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsName(String name) {
        Check.notNull(name, "name");
        Object object = this.lock;
        synchronized (object) {
            return this.findByName(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryItem getItemByID(GUID id) {
        Check.notNull(id, "id");
        Object object = this.lock;
        synchronized (object) {
            QueryItem item = this.findByID(id);
            if (item != null) {
                return item;
            }
        }
        throw new IllegalArgumentException(Messages.getString("QueryFolder.SpecifiedKeyWasNotFound"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryItem getItemByName(String name) {
        Check.notNull(name, "name");
        Object object = this.lock;
        synchronized (object) {
            QueryItem item = this.findByName(name);
            if (item != null) {
                return item;
            }
        }
        throw new IllegalArgumentException(Messages.getString("QueryFolder.SpecifiedKeyWasNotFound"));
    }

    protected boolean isRootNode() {
        QueryHierarchy queryHierarchy;
        return this.getProject() != null && ((queryHierarchy = this.getProject().getQueryHierarchy()).containsID(this.getID()) || this == queryHierarchy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(QueryItem item) {
        Check.notNull(item, "item");
        QueryFolder parent = null;
        Object object = this.lock;
        synchronized (object) {
            if (item == this) {
                throw new IllegalArgumentException(Messages.getString("QueryFolder.CannotAddSelfAsChild"));
            }
            if (item.isDeleted()) {
                throw new IllegalArgumentException(Messages.getString("QueryFolder.CannotAddDeletedItems"));
            }
            if (this.isDeleted()) {
                throw new IllegalArgumentException(Messages.getString("QueryFolder.CannotAddToADeletedFolder"));
            }
            if (this.getProject() != null && !this.getProject().getQueryHierarchy().supportsFolders() && item instanceof QueryFolder) {
                throw new IllegalArgumentException(Messages.getString("QueryFolder.ServerDoesNotSupportFolders"));
            }
            if (item instanceof QueryFolderImpl && ((QueryFolderImpl)item).isRootNode()) {
                throw new IllegalArgumentException(Messages.getString("QueryFolder.RootNodesMayNotBeModified"));
            }
            if (this.getProject() != null && this.getProject().getQueryHierarchy() == this) {
                throw new IllegalArgumentException(Messages.getString("QueryFolder.RootNodesMayNotBeModified"));
            }
            if (this.getProject() != null && item.getProject() != null && this.getProject().getWorkItemClient() != item.getProject().getWorkItemClient()) {
                throw new IllegalArgumentException(Messages.getString("QueryFolder.AddingAcrossStoresIsProhibited"));
            }
            if (this.getProject() != null && item.getProject() != null && this.getProject() != item.getProject() && !this.isNew() && !item.isNew()) {
                throw new IllegalArgumentException(Messages.getString("QueryFolder.MovingBetweenProjectsIsProhibited"));
            }
            for (QueryFolder folder = this.getParent(); folder != null; folder = folder.getParent()) {
                if (folder != item) continue;
                throw new IllegalArgumentException(Messages.getString("QueryFolder.CannotAddParentAsAChild"));
            }
            if (this.containsID(item.getID())) {
                return;
            }
            this.checkForDuplicateName(item, item.getName());
            parent = item.getParent();
            this.addInternal(item, true);
        }
        if (parent != null && parent != this && parent instanceof QueryFolderImpl) {
            ((QueryFolderImpl)parent).onContentsChanged(item, QueryFolderAction.REMOVED);
        }
        this.onContentsChanged(item, QueryFolderAction.ADDED);
    }

    protected void addInternal(QueryItem item, boolean updateChangedLists) {
        if (item.getParent() != null && item.getParent() != this && item.getParent() instanceof QueryFolderImpl) {
            ((QueryFolderImpl)item.getParent()).deleteInternal(item, updateChangedLists);
        }
        this.items.add(item);
        this.needsSort = true;
        if (item instanceof QueryItemImpl) {
            ((QueryItemImpl)item).setParent(this);
        }
        if (updateChangedLists) {
            if (this.removedItems != null && this.removedItems.contains(item)) {
                this.removedItems.remove(item);
            } else {
                if (this.addedItems == null) {
                    this.addedItems = new ArrayList<QueryItem>();
                }
                this.addedItems.add(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteInternal(QueryItem item, boolean updateChangedLists) {
        Object object = this.lock;
        synchronized (object) {
            this.items.remove(item);
            if (updateChangedLists) {
                this.updateChangedListsOnRemove(item);
            }
        }
        if (item instanceof QueryItemImpl) {
            ((QueryItemImpl)item).setParent(null);
        }
    }

    @Override
    protected void resetInternal() {
        QueryItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof QueryItemImpl)) continue;
            ((QueryItemImpl)items[i]).resetInternal();
        }
        if (this.removedItems != null) {
            QueryItem[] removedItemArray = this.removedItems.toArray(new QueryItem[this.removedItems.size()]);
            for (int i = 0; i < removedItemArray.length; ++i) {
                if (!(removedItemArray[i] instanceof QueryItemImpl)) continue;
                ((QueryItemImpl)removedItemArray[i]).resetInternal();
            }
        }
        super.resetInternal();
    }

    void checkForDuplicateName(QueryItem item, String name) {
        Check.notNull(item, "item");
        Check.notNull(name, "name");
        QueryItem namedItem = this.findByName(name);
        if (namedItem != null && namedItem != item) {
            throw new WorkItemException(MessageFormat.format(Messages.getString("QueryFolder.NameConflictForQueryFormat"), name));
        }
    }

    private QueryItem findByName(String name) {
        Check.notNull(name, "name");
        for (QueryItem item : this.items) {
            if (!item.getName().equalsIgnoreCase(name)) continue;
            return item;
        }
        return null;
    }

    void updateName(QueryItem item, String newName) {
        this.needsSort = true;
        if (item instanceof QueryItemImpl) {
            ((QueryItemImpl)item).setNameInternal(newName);
        }
    }

    private void updateChangedListsOnRemove(QueryItem item) {
        if (this.addedItems != null && this.addedItems.contains(item)) {
            this.addedItems.remove(item);
        } else {
            if (this.removedItems == null) {
                this.removedItems = new ArrayList<QueryItem>();
            }
            this.removedItems.add(item);
        }
    }

    @Override
    protected void onMoveChangedHierarchy() {
        super.onMoveChangedHierarchy();
        this.updateAttributes(this);
    }

    private void updateAttributes(QueryFolder queryFolder) {
        QueryItem[] children = queryFolder.getItems();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof QueryItemImpl) {
                ((QueryItemImpl)children[i]).setProject(this.getProject());
                ((QueryItemImpl)children[i]).setPersonal(this.isPersonal());
            }
            if (!(children[i] instanceof QueryFolder)) continue;
            this.updateAttributes((QueryFolder)children[i]);
        }
    }

    protected void onContentsChanged(QueryItem item, QueryFolderAction action) {
    }

    private QueryItem findByID(GUID id) {
        for (QueryItem item : this.items) {
            if (!item.getID().equals(id)) continue;
            return item;
        }
        return null;
    }

    protected void updateCollectionsForRemove(QueryItem item) {
        QueryItem existingItem = this.findByID(item.getID());
        if (existingItem == null) {
            this.removedItems.remove(item);
        } else {
            this.items.remove(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWithLock(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            runnable.run();
        }
    }

    protected void onAddSaved(QueryItem item) {
        this.addedItems.remove(item);
        this.fireAdd(item);
    }

    protected void onUpdateSaved(QueryItem item) {
        this.fireUpdate(item);
    }

    protected void onDeleteSaved(QueryItem item) {
        this.updateCollectionsForRemove(item);
        this.fireDelete(item);
    }

    private void fireAdd(QueryItem item) {
        this.onChangesCommitted(item, QueryFolderAction.ADDED);
    }

    private void fireUpdate(QueryItem item) {
        this.onChangesCommitted(item, QueryFolderAction.CHANGED);
    }

    private void fireDelete(QueryItem item) {
        this.onChangesCommitted(item, QueryFolderAction.REMOVED);
    }

    private void onChangesCommitted(QueryItem item, QueryFolderAction action) {
    }

    @Override
    protected void validate(WITContext context) {
        QueryItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof QueryItemImpl)) continue;
            ((QueryItemImpl)items[i]).validate(context);
        }
    }

    protected QueryItem[] getRemovedItems() {
        if (this.removedItems == null) {
            return new QueryItem[0];
        }
        return this.removedItems.toArray(new QueryItem[this.removedItems.size()]);
    }

    @Override
    public QueryItemType getType() {
        if (GUID.EMPTY.toString().replaceAll("-", "").equals(this.getID())) {
            return QueryItemType.PROJECT;
        }
        return QueryItemType.QUERY_FOLDER;
    }

    private static final class QueryItemComparator
    implements Comparator<QueryItem> {
        private QueryItemComparator() {
        }

        @Override
        public int compare(QueryItem item0, QueryItem item1) {
            boolean folder0 = item0 instanceof QueryFolder;
            boolean folder1 = item1 instanceof QueryFolder;
            if (folder0 == folder1) {
                return Collator.getInstance().compare(item0.getName(), item1.getName());
            }
            if (folder0) {
                return -1;
            }
            return 1;
        }
    }
}

