/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.link;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;

public class WorkItemLinkUtils {
    public static String buildDescriptionFromWorkItems(WorkItem[] workItems) {
        if (workItems == null || workItems.length == 0) {
            return "";
        }
        if (workItems.length == 1) {
            return WorkItemLinkUtils.buildDescriptionFromWorkItem(workItems[0]);
        }
        return Messages.getString("WorkItemLinkUtils.ParentheticalMultipleWorkItemsSelectedMessage");
    }

    public static String buildDescriptionFromWorkItem(WorkItem workItem) {
        if (workItem == null) {
            return "";
        }
        String rawTitle = (String)workItem.getFields().getField("System.Title").getValue();
        String title = rawTitle != null && rawTitle.trim().length() > 0 ? rawTitle : "";
        return MessageFormat.format("{0} {1}: {2}", workItem.getFields().getWorkItemType(), Integer.toString(workItem.getFields().getID()), title);
    }

    public static String buildCommaSeparatedWorkItemIDList(WorkItem[] workItems) {
        StringBuffer ids = new StringBuffer();
        if (workItems != null) {
            for (int i = 0; i < workItems.length; ++i) {
                if (i > 0) {
                    ids.append(", ");
                }
                ids.append(String.valueOf(workItems[i].getID()));
            }
        }
        return ids.toString();
    }

    public static int[] buildWorkItemIDListFromText(String textIds) throws NumberFormatException {
        Check.notNull(textIds, "textIds");
        String remainingChars = textIds.replaceAll("[\\d\\s,]", "");
        if (remainingChars.length() > 0) {
            throw new NumberFormatException(Messages.getString("WorkItemLinkUtils.WorkItemListContainsInvalidCharacters"));
        }
        textIds = textIds.replaceAll("\\D", " ");
        textIds = textIds.trim();
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] ids = textIds.split(" ");
        for (int i = 0; i < ids.length; ++i) {
            String textId = ids[i].trim();
            if (textId.length() <= 0) continue;
            int value = Integer.valueOf(textId);
            if (value == 0) {
                throw new NumberFormatException(Messages.getString("WorkItemLinkUtils.WorkItemListContainsInvalidCharacters"));
            }
            list.add(value);
        }
        int[] intIds = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            intIds[i] = (Integer)list.get(i);
        }
        return intIds;
    }
}

