/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.config.tfproxy;

import com.microsoft.tfs.core.TFProxyServerSettings;

public class DefaultTFProxyServerSettings
implements TFProxyServerSettings {
    public static final long DEFAULT_DISABLE_INTERVAL_MILLIS = 300000L;
    private final long disableIntervalMillis;
    private final Object lock = new Object();
    private String url;
    private long disableEndTime;

    public DefaultTFProxyServerSettings(String url) {
        this(url, 300000L);
    }

    public DefaultTFProxyServerSettings(String url, long disableIntervalMillis) {
        this.setURL(url);
        this.disableIntervalMillis = disableIntervalMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String url) {
        Object object = this.lock;
        synchronized (object) {
            this.url = url;
            this.disableEndTime = -1L;
        }
    }

    public long getDisableInternalMillis() {
        return this.disableIntervalMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordFailure() {
        Object object = this.lock;
        synchronized (object) {
            this.disableEndTime = System.currentTimeMillis() + this.disableIntervalMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable() {
        Object object = this.lock;
        synchronized (object) {
            if (this.url == null) {
                return false;
            }
            return System.currentTimeMillis() > this.disableEndTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getURL() {
        Object object = this.lock;
        synchronized (object) {
            return this.url;
        }
    }
}

