/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient;

import com.microsoft.tfs.core.httpclient.Header;
import com.microsoft.tfs.core.httpclient.HostConfiguration;
import com.microsoft.tfs.core.httpclient.HttpConnection;
import com.microsoft.tfs.core.httpclient.HttpException;
import com.microsoft.tfs.core.httpclient.HttpMethod;
import com.microsoft.tfs.core.httpclient.HttpMethodBase;
import com.microsoft.tfs.core.httpclient.HttpState;
import com.microsoft.tfs.core.httpclient.URI;
import com.microsoft.tfs.core.httpclient.URIException;
import com.microsoft.tfs.core.httpclient.Wire;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectMethod
extends HttpMethodBase {
    public static final String NAME = "CONNECT";
    private final HostConfiguration targethost;
    private static final Log LOG = LogFactory.getLog(ConnectMethod.class);

    @Deprecated
    public ConnectMethod() {
        this.targethost = null;
    }

    @Deprecated
    public ConnectMethod(HttpMethod method) {
        this.targethost = null;
    }

    public ConnectMethod(HostConfiguration targethost) {
        if (targethost == null) {
            throw new IllegalArgumentException("Target host may not be null");
        }
        this.targethost = targethost;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getPath() {
        if (this.targethost != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.targethost.getHost());
            int port = this.targethost.getPort();
            if (port == -1) {
                port = this.targethost.getProtocol().getDefaultPort();
            }
            buffer.append(':');
            buffer.append(port);
            return buffer.toString();
        }
        return "/";
    }

    @Override
    public URI getURI() throws URIException {
        String path = "https://" + this.getPath();
        String charset = this.getParams().getUriCharset();
        return new URI(path, true, charset);
    }

    @Override
    protected void addCookieRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
    }

    @Override
    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter ConnectMethod.addRequestHeaders(HttpState, HttpConnection)");
        this.addUserAgentRequestHeader(state, conn);
        this.addHostRequestHeader(state, conn);
        this.addProxyConnectionHeader(state, conn);
    }

    @Override
    public int execute(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter ConnectMethod.execute(HttpState, HttpConnection)");
        int code = super.execute(state, conn);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CONNECT status code " + code));
        }
        return code;
    }

    @Override
    protected void writeRequestLine(HttpState state, HttpConnection conn) throws IOException, HttpException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(' ');
        if (this.targethost != null) {
            buffer.append(this.getPath());
        } else {
            int port = conn.getPort();
            if (port == -1) {
                port = conn.getProtocol().getDefaultPort();
            }
            buffer.append(conn.getHost());
            buffer.append(':');
            buffer.append(port);
        }
        buffer.append(" ");
        buffer.append(this.getEffectiveVersion());
        String line = buffer.toString();
        conn.printLine(line, this.getParams().getHttpElementCharset());
        if (Wire.HEADER_WIRE.enabled()) {
            Wire.HEADER_WIRE.output(line);
        }
    }

    @Override
    protected boolean shouldCloseConnection(HttpConnection conn) {
        if (this.getStatusCode() == 200) {
            Header connectionHeader = null;
            if (!conn.isTransparent()) {
                connectionHeader = this.getResponseHeader("proxy-connection");
            }
            if (connectionHeader == null) {
                connectionHeader = this.getResponseHeader("connection");
            }
            if (connectionHeader != null && connectionHeader.getValue().equalsIgnoreCase("close") && LOG.isWarnEnabled()) {
                LOG.warn((Object)("Invalid header encountered '" + connectionHeader.toExternalForm() + "' in response " + this.getStatusLine().toString()));
            }
            return false;
        }
        return super.shouldCloseConnection(conn);
    }
}

