/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient;

import com.microsoft.tfs.core.httpclient.HttpMethod;
import com.microsoft.tfs.core.httpclient.HttpMethodBase;
import com.microsoft.tfs.core.httpclient.HttpMethodRetryHandler;
import com.microsoft.tfs.core.httpclient.NoHttpResponseException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;

public class DefaultHttpMethodRetryHandler
implements HttpMethodRetryHandler {
    private static final String MAX_REQUEST_RETRY_PROPERTY = "com.microsoft.tfs.core.maxRequestRetry";
    private static final int MAX_REQUEST_RETRY_DEFAULT = 3;
    private static Class SSL_HANDSHAKE_EXCEPTION = null;
    private final int retryCount;
    private final boolean requestSentRetryEnabled;

    public DefaultHttpMethodRetryHandler(int retryCount, boolean requestSentRetryEnabled) {
        this.retryCount = retryCount;
        this.requestSentRetryEnabled = requestSentRetryEnabled;
    }

    public DefaultHttpMethodRetryHandler() {
        this(Integer.getInteger(MAX_REQUEST_RETRY_PROPERTY, 3), false);
    }

    @Override
    public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
        if (method == null) {
            throw new IllegalArgumentException("HTTP method may not be null");
        }
        if (exception == null) {
            throw new IllegalArgumentException("Exception parameter may not be null");
        }
        if (method instanceof HttpMethodBase && ((HttpMethodBase)method).isAborted()) {
            return false;
        }
        if (executionCount > this.retryCount) {
            return false;
        }
        if (exception instanceof NoHttpResponseException) {
            return true;
        }
        if (exception instanceof InterruptedIOException || exception instanceof SocketException) {
            return !method.isRequestSent();
        }
        if (exception instanceof UnknownHostException) {
            return false;
        }
        if (exception instanceof NoRouteToHostException) {
            return false;
        }
        if (SSL_HANDSHAKE_EXCEPTION != null && SSL_HANDSHAKE_EXCEPTION.isInstance(exception)) {
            return false;
        }
        return !method.isRequestSent() || this.requestSentRetryEnabled;
    }

    public boolean isRequestSentRetryEnabled() {
        return this.requestSentRetryEnabled;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    static {
        try {
            SSL_HANDSHAKE_EXCEPTION = Class.forName("javax.net.ssl.SSLHandshakeException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

