/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient.util;

import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExceptionUtil {
    private static final Log LOG = LogFactory.getLog(ExceptionUtil.class);
    private static final Method INIT_CAUSE_METHOD = ExceptionUtil.getInitCauseMethod();

    private static Method getInitCauseMethod() {
        try {
            Class[] paramsClasses = new Class[]{Throwable.class};
            return Throwable.class.getMethod("initCause", paramsClasses);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static void initCause(Throwable throwable, Throwable cause) {
        if (INIT_CAUSE_METHOD != null) {
            try {
                INIT_CAUSE_METHOD.invoke((Object)throwable, cause);
            }
            catch (Exception e) {
                LOG.warn((Object)"Exception invoking Throwable.initCause", (Throwable)e);
            }
        }
    }

    public static boolean isSocketTimeoutException(InterruptedIOException e) {
        return e instanceof SocketTimeoutException;
    }
}

