/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.search.internal;

import com.microsoft.tfs.core.search.IVSSearchQuery;
import com.microsoft.tfs.core.search.IVSSearchToken;
import com.microsoft.tfs.core.search.internal.VSSearchQueryParser;
import java.util.ArrayList;
import java.util.List;

public class VSSearchQuery
implements IVSSearchQuery {
    private final List<IVSSearchToken> searchTokens = new ArrayList<IVSSearchToken>();
    private final String searchString;
    private int parseError;
    private boolean stringParsed;

    public VSSearchQuery(String searchString) {
        this.searchString = searchString;
        this.parseError = 0;
    }

    public boolean isStringParsed() {
        return this.stringParsed;
    }

    public void setStringParsed(boolean stringParsed) {
        this.stringParsed = stringParsed;
    }

    @Override
    public String getSearchString() {
        return this.searchString;
    }

    @Override
    public int getParseError() {
        this.ensureSearchStringParsed();
        return this.parseError;
    }

    public void setParseError(int parseError) {
        this.parseError = parseError;
    }

    @Override
    public int getTokens(int maxTokens, IVSSearchToken[] rgpSearchTokens) {
        this.ensureSearchStringParsed();
        if (rgpSearchTokens == null) {
            if (maxTokens > 0) {
                throw new IllegalArgumentException("maxTokens must be 0 when rgpSearchTokens is null");
            }
            return this.searchTokens.size();
        }
        if (maxTokens > rgpSearchTokens.length) {
            throw new IllegalArgumentException("maxTokens must not be greater than rgpSearchTokens.length");
        }
        int tokensReturned = Math.min(maxTokens, this.searchTokens.size());
        for (int i = 0; i < tokensReturned; ++i) {
            rgpSearchTokens[i] = this.searchTokens.get(i);
        }
        return tokensReturned;
    }

    private void ensureSearchStringParsed() {
        if (this.isStringParsed()) {
            return;
        }
        VSSearchQueryParser.parseSearchString(this.searchString, new VSSearchQueryParser.TokenFoundCallback(){

            @Override
            public void call(IVSSearchToken searchToken) {
                VSSearchQuery.this.searchTokens.add(searchToken);
                VSSearchQuery.this.parseError |= searchToken.getParseError();
            }
        });
        this.setStringParsed(true);
    }
}

