/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.valid;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.valid.IValidationMessage;
import com.microsoft.tfs.util.valid.IValidity;
import com.microsoft.tfs.util.valid.Severity;
import com.microsoft.tfs.util.valid.ValidationMessage;

public class Validity
implements IValidity {
    public static final Validity VALID = new Validity(Severity.OK);
    public static final Validity INVALID = new Validity(Severity.ERROR);
    private final Severity severity;
    private final IValidationMessage[] messages;

    public static Validity invalid(String errorMessage) {
        if (errorMessage == null) {
            return INVALID;
        }
        ValidationMessage validationMessage = new ValidationMessage(errorMessage, Severity.ERROR);
        return new Validity(validationMessage);
    }

    public Validity(IValidationMessage message) {
        this(new IValidationMessage[]{message});
    }

    public Validity(IValidationMessage[] messages) {
        Check.notNull(messages, "messages");
        if (messages.length == 0) {
            throw new IllegalArgumentException("messages length is 0");
        }
        this.messages = (IValidationMessage[])messages.clone();
        Severity maxSeverity = null;
        for (int i = 0; i < messages.length; ++i) {
            if (messages[i] == null) {
                throw new IllegalArgumentException("message " + i + " is null");
            }
            if (maxSeverity != null && messages[i].getSeverity().getPriority() <= maxSeverity.getPriority()) continue;
            maxSeverity = messages[i].getSeverity();
        }
        this.severity = maxSeverity;
    }

    public Validity(Severity severity) {
        Check.notNull(severity, "severity");
        this.severity = severity;
        this.messages = null;
    }

    @Override
    public IValidationMessage getFirstMessage() {
        if (this.messages == null) {
            return null;
        }
        for (int i = 0; i < this.messages.length; ++i) {
            if (this.messages[i].getSeverity() != this.severity) continue;
            return this.messages[i];
        }
        throw new IllegalStateException("unexpected condition");
    }

    @Override
    public IValidationMessage[] getMessages() {
        if (this.messages == null) {
            return new IValidationMessage[0];
        }
        return (IValidationMessage[])this.messages.clone();
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public boolean isValid() {
        return Severity.ERROR != this.severity;
    }
}

