/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.com.intellij.lang.java.lexer.JavaLexer;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\bJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R*\u0010\u0006\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0007j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0003`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/SingleJavaFileRootsIndex;", "", "roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "(Ljava/util/List;)V", "classIdsInRoots", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lkotlin/collections/ArrayList;", "findJavaSourceClass", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "classId", "findJavaSourceClasses", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getClassIdsForRootAt", "index", "", "JavaSourceClassIdReader", "cli-base"})
@SourceDebugExtension(value={"SMAP\nSingleJavaFileRootsIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleJavaFileRootsIndex.kt\norg/jetbrains/kotlin/cli/jvm/index/SingleJavaFileRootsIndex\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1#2:127\n1360#3:128\n1446#3,5:129\n766#3:134\n857#3,2:135\n*S KotlinDebug\n*F\n+ 1 SingleJavaFileRootsIndex.kt\norg/jetbrains/kotlin/cli/jvm/index/SingleJavaFileRootsIndex\n*L\n44#1:128\n44#1:129,5\n44#1:134\n44#1:135,2\n*E\n"})
public final class SingleJavaFileRootsIndex {
    @NotNull
    private final List<JavaRoot> roots;
    @NotNull
    private final ArrayList<List<ClassId>> classIdsInRoots;

    public SingleJavaFileRootsIndex(@NotNull List<JavaRoot> roots2) {
        Intrinsics.checkNotNullParameter(roots2, "roots");
        this.roots = roots2;
        Iterator<JavaRoot> iterator2 = this.roots.iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            VirtualFile file2 = iterator2.next().component1();
            boolean bl2 = bl = !file2.isDirectory();
            if (!_Assertions.ENABLED || bl) continue;
            boolean bl3 = false;
            String string2 = "Should not be a directory: " + file2;
            throw new AssertionError((Object)string2);
        }
        this.classIdsInRoots = new ArrayList(this.roots.size());
    }

    @Nullable
    public final VirtualFile findJavaSourceClass(@NotNull ClassId classId) {
        VirtualFile virtualFile2;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(classId, "classId");
            Iterable iterable = CollectionsKt.getIndices((Collection)this.roots);
            for (Object t : iterable) {
                int index2 = ((Number)t).intValue();
                boolean bl = false;
                if (!this.getClassIdsForRootAt(index2).contains(classId)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Integer n = v0;
        if (n != null) {
            int index3 = ((Number)n).intValue();
            boolean bl = false;
            virtualFile2 = this.roots.get(index3).getFile();
        } else {
            virtualFile2 = null;
        }
        return virtualFile2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ClassId> findJavaSourceClasses(@NotNull FqName packageFqName) {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Iterable $this$flatMap$iv = CollectionsKt.getIndices((Collection)this.roots);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv$iv;
            int p0 = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Iterable list$iv$iv = this.getClassIdsForRootAt(p0);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClassId root = (ClassId)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(root.getPackageFqName(), packageFqName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<ClassId> getClassIdsForRootAt(int index2) {
        int i = this.classIdsInRoots.size();
        if (i <= index2) {
            while (true) {
                this.classIdsInRoots.add(new JavaSourceClassIdReader(this.roots.get(i).getFile()).readClassIds());
                if (i == index2) break;
                ++i;
            }
        }
        List<ClassId> list2 = this.classIdsInRoots.get(index2);
        Intrinsics.checkNotNullExpressionValue(list2, "get(...)");
        return list2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\rH\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/SingleJavaFileRootsIndex$JavaSourceClassIdReader;", "", "file", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "braceBalance", "", "lexer", "Lorg/jetbrains/kotlin/com/intellij/lang/java/lexer/JavaLexer;", "parenthesisBalance", "advance", "", "at", "", "type", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "atClass", "atRecord", "end", "readClassIds", "", "Lorg/jetbrains/kotlin/name/ClassId;", "tokenText", "", "Companion", "cli-base"})
    private static final class JavaSourceClassIdReader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final JavaLexer lexer;
        private int braceBalance;
        private int parenthesisBalance;
        @NotNull
        private static final Set<IElementType> CLASS_KEYWORDS;

        /*
         * WARNING - void declaration
         */
        public JavaSourceClassIdReader(@NotNull VirtualFile file2) {
            void $this$lexer_u24lambda_u240;
            JavaLexer javaLexer;
            Intrinsics.checkNotNullParameter(file2, "file");
            JavaLexer javaLexer2 = javaLexer = new JavaLexer(LanguageLevel.HIGHEST);
            JavaSourceClassIdReader javaSourceClassIdReader = this;
            boolean bl = false;
            byte[] byArray = file2.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "contentsToByteArray(...)");
            byte[] byArray2 = byArray;
            $this$lexer_u24lambda_u240.start(new String(byArray2, Charsets.UTF_8));
            javaSourceClassIdReader.lexer = javaLexer;
        }

        private final boolean at(IElementType type2) {
            return Intrinsics.areEqual(this.lexer.getTokenType(), type2);
        }

        private final boolean end() {
            return this.lexer.getTokenType() == null;
        }

        private final void advance() {
            IElementType iElementType = ElementType.LBRACE;
            Intrinsics.checkNotNullExpressionValue(iElementType, "LBRACE");
            if (this.at(iElementType)) {
                int n = this.braceBalance;
                this.braceBalance = n + 1;
            } else {
                IElementType iElementType2 = ElementType.RBRACE;
                Intrinsics.checkNotNullExpressionValue(iElementType2, "RBRACE");
                if (this.at(iElementType2)) {
                    int n = this.braceBalance;
                    this.braceBalance = n + -1;
                } else {
                    IElementType iElementType3 = ElementType.LPARENTH;
                    Intrinsics.checkNotNullExpressionValue(iElementType3, "LPARENTH");
                    if (this.at(iElementType3)) {
                        int n = this.parenthesisBalance;
                        this.parenthesisBalance = n + 1;
                    } else {
                        IElementType iElementType4 = ElementType.RPARENTH;
                        Intrinsics.checkNotNullExpressionValue(iElementType4, "RPARENTH");
                        if (this.at(iElementType4)) {
                            int n = this.parenthesisBalance;
                            this.parenthesisBalance = n + -1;
                        }
                    }
                }
            }
            this.lexer.advance();
        }

        private final String tokenText() {
            String string2 = this.lexer.getTokenText();
            Intrinsics.checkNotNullExpressionValue(string2, "getTokenText(...)");
            return string2;
        }

        private final boolean atClass() {
            return this.braceBalance == 0 && this.parenthesisBalance == 0 && (CLASS_KEYWORDS.contains(this.lexer.getTokenType()) || this.atRecord());
        }

        private final boolean atRecord() {
            IElementType iElementType = ElementType.IDENTIFIER;
            Intrinsics.checkNotNullExpressionValue(iElementType, "IDENTIFIER");
            return this.at(iElementType) && Intrinsics.areEqual(this.tokenText(), "record");
        }

        @NotNull
        public final List<ClassId> readClassIds() {
            FqName packageFqName;
            block8: {
                packageFqName = FqName.ROOT;
                while (!this.end()) {
                    IElementType iElementType = ElementType.PACKAGE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue(iElementType, "PACKAGE_KEYWORD");
                    if (this.at(iElementType) || this.atClass()) break;
                    this.advance();
                }
                IElementType iElementType = ElementType.PACKAGE_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(iElementType, "PACKAGE_KEYWORD");
                if (!this.at(iElementType)) break block8;
                StringBuilder packageName = new StringBuilder();
                while (!this.end()) {
                    block10: {
                        block9: {
                            IElementType iElementType2 = ElementType.SEMICOLON;
                            Intrinsics.checkNotNullExpressionValue(iElementType2, "SEMICOLON");
                            if (this.at(iElementType2)) break;
                            IElementType iElementType3 = ElementType.IDENTIFIER;
                            Intrinsics.checkNotNullExpressionValue(iElementType3, "IDENTIFIER");
                            if (this.at(iElementType3)) break block9;
                            IElementType iElementType4 = ElementType.DOT;
                            Intrinsics.checkNotNullExpressionValue(iElementType4, "DOT");
                            if (!this.at(iElementType4)) break block10;
                        }
                        packageName.append(this.tokenText());
                    }
                    this.advance();
                }
                packageFqName = new FqName(packageName.toString());
            }
            ArrayList<ClassId> result2 = new ArrayList<ClassId>(1);
            while (true) {
                if (!this.end() && !this.atClass()) {
                    this.advance();
                    continue;
                }
                if (this.end()) break;
                this.advance();
                while (!this.end()) {
                    IElementType iElementType = ElementType.IDENTIFIER;
                    Intrinsics.checkNotNullExpressionValue(iElementType, "IDENTIFIER");
                    if (this.at(iElementType)) break;
                    this.advance();
                }
                if (this.end()) break;
                result2.add(new ClassId(packageFqName, Name.identifier(this.tokenText())));
            }
            return result2;
        }

        static {
            IElementType[] iElementTypeArray = new IElementType[]{ElementType.CLASS_KEYWORD, ElementType.INTERFACE_KEYWORD, ElementType.ENUM_KEYWORD};
            CLASS_KEYWORDS = SetsKt.setOf(iElementTypeArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/SingleJavaFileRootsIndex$JavaSourceClassIdReader$Companion;", "", "()V", "CLASS_KEYWORDS", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "cli-base"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

