/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationTargetUtil;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationUtil;
import org.jetbrains.kotlin.com.intellij.codeInsight.Nullability;
import org.jetbrains.kotlin.com.intellij.codeInsight.NullabilityAnnotationInfo;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public abstract class NullableNotNullManager {
    protected static final Logger LOG = Logger.getInstance(NullableNotNullManager.class);
    protected final Project myProject;

    protected NullableNotNullManager(Project project) {
        this.myProject = project;
    }

    @NotNull
    public abstract Optional<Nullability> getAnnotationNullability(String var1);

    public abstract boolean isTypeUseAnnotationLocationRestricted(String var1);

    public abstract boolean canAnnotateLocals(String var1);

    public static NullableNotNullManager getInstance(Project project) {
        return project.getService(NullableNotNullManager.class);
    }

    public abstract void setNotNulls(String ... var1);

    public abstract void setNullables(String ... var1);

    @NotNull
    public abstract String getDefaultNullable();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public PsiAnnotation getNullableAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(0);
        }
        if ((info = this.findEffectiveNullabilityInfo(owner)) == null || info.getNullability() != Nullability.NULLABLE) {
            return null;
        }
        if (!checkBases && info.getInheritedFrom() != null) {
            return null;
        }
        return info.getAnnotation();
    }

    public abstract void setDefaultNullable(@NotNull String var1);

    @NotNull
    public abstract String getDefaultNotNull();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public PsiAnnotation getNotNullAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(1);
        }
        if ((info = this.findEffectiveNullabilityInfo(owner)) == null || info.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        if (!checkBases && info.getInheritedFrom() != null) {
            return null;
        }
        return info.getAnnotation();
    }

    @Nullable
    public PsiAnnotation copyNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(2);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(3);
        }
        if ((info = this.findOwnNullabilityInfo(original)) == null || info.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(4);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(5);
        }
        if ((info = this.findOwnNullabilityInfo(original)) == null || info.getNullability() != Nullability.NULLABLE) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableOrNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo src;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(6);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(7);
        }
        if ((src = this.findOwnNullabilityInfo(original)) == null) {
            return null;
        }
        NullabilityAnnotationInfo effective = this.findEffectiveNullabilityInfo(generated);
        if (effective != null && effective.getNullability() == src.getNullability()) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(src.getAnnotation(), generated);
    }

    @Nullable
    private static PsiAnnotation copyAnnotation(@NotNull PsiAnnotation annotation2, @NotNull PsiModifierListOwner target) {
        String qualifiedName2;
        if (annotation2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(8);
        }
        if (target == null) {
            NullableNotNullManager.$$$reportNull$$$0(9);
        }
        if ((qualifiedName2 = annotation2.getQualifiedName()) != null) {
            if (JavaPsiFacade.getInstance(annotation2.getProject()).findClass(qualifiedName2, target.getResolveScope()) == null) {
                return null;
            }
            PsiModifierList modifierList2 = target.getModifierList();
            if (modifierList2 != null && !AnnotationTargetUtil.isStrictlyTypeUseAnnotation(modifierList2, annotation2) && !modifierList2.hasAnnotation(qualifiedName2)) {
                return modifierList2.addAnnotation(qualifiedName2);
            }
        }
        return null;
    }

    public abstract void setDefaultNotNull(@NotNull String var1);

    @Nullable
    public NullabilityAnnotationInfo findOwnNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(10);
        }
        if ((info = this.findEffectiveNullabilityInfo(owner)) == null || info.isContainer() || info.getInheritedFrom() != null) {
            return null;
        }
        return info;
    }

    @Nullable
    public NullabilityAnnotationInfo findExplicitNullability(PsiModifierListOwner owner) {
        NullabilityAnnotationInfo result2 = this.findPlainAnnotation(owner, false, true, this.getAllNullabilityAnnotationsWithNickNames());
        if (result2 != null) {
            return result2;
        }
        return this.findNullityDefaultInHierarchy(owner);
    }

    @Nullable
    public NullabilityAnnotationInfo findEffectiveNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        PsiType type2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(11);
        }
        if ((type2 = NullableNotNullManager.getOwnerType(owner)) == null || TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return null;
        }
        return (NullabilityAnnotationInfo)CachedValuesManager.getCachedValue(owner, () -> CachedValueProvider.Result.create(this.doFindEffectiveNullabilityAnnotation(owner), PsiModificationTracker.MODIFICATION_COUNT));
    }

    @Nullable
    private NullabilityAnnotationInfo doFindEffectiveNullabilityAnnotation(@NotNull PsiModifierListOwner owner) {
        List<PsiParameter> superParameters;
        NullabilityAnnotationInfo defaultInfo;
        boolean lambdaParameter;
        NullabilityAnnotationInfo result2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(12);
        }
        if ((result2 = this.findPlainAnnotation(owner, true, false, this.getAllNullabilityAnnotationsWithNickNames())) != null) {
            return result2;
        }
        boolean bl = lambdaParameter = owner instanceof PsiParameter && owner.getParent() instanceof PsiParameterList && owner.getParent().getParent() instanceof PsiLambdaExpression;
        if (!lambdaParameter && (defaultInfo = this.findNullityDefaultFiltered(owner)) != null) {
            return defaultInfo;
        }
        if (owner instanceof PsiParameter && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            for (PsiParameter parameter : superParameters) {
                NullabilityAnnotationInfo plain = this.findPlainAnnotation(parameter, false, false, this.getAllNullabilityAnnotationsWithNickNames());
                if (plain != null) {
                    return null;
                }
                NullabilityAnnotationInfo defaultInfo2 = this.findNullityDefaultInHierarchy(parameter);
                if (defaultInfo2 == null) continue;
                return defaultInfo2.getNullability() == Nullability.NOT_NULL ? defaultInfo2.withInheritedFrom(parameter) : null;
            }
            return null;
        }
        if (lambdaParameter) {
            return this.findNullityDefaultFiltered(owner);
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo findNullityDefaultFiltered(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo defaultInfo;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(13);
        }
        if (!((defaultInfo = this.findNullityDefaultInHierarchy(owner)) == null || defaultInfo.getNullability() != Nullability.NULLABLE && this.hasHardcodedContracts(owner))) {
            return defaultInfo;
        }
        return null;
    }

    @Nullable
    public PsiAnnotation findExplicitNullabilityAnnotation(@NotNull PsiModifierListOwner owner, @NotNull Collection<Nullability> nullabilities) {
        NullabilityAnnotationDataHolder holder2;
        Set filteredSet;
        NullabilityAnnotationDataHolder filtered;
        NullabilityAnnotationInfo result2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(14);
        }
        if (nullabilities == null) {
            NullableNotNullManager.$$$reportNull$$$0(15);
        }
        return (result2 = this.findPlainAnnotation(owner, false, false, filtered = new NullabilityAnnotationDataHolder(filteredSet = (holder2 = this.getAllNullabilityAnnotationsWithNickNames()).qualifiedNames().stream().filter(qName -> nullabilities.contains((Object)holder2.getNullability((String)qName))).collect(Collectors.toSet()), holder2, nullabilities){
            final /* synthetic */ Set val$filteredSet;
            final /* synthetic */ NullabilityAnnotationDataHolder val$holder;
            final /* synthetic */ Collection val$nullabilities;
            {
                this.val$filteredSet = set;
                this.val$holder = nullabilityAnnotationDataHolder;
                this.val$nullabilities = collection;
            }

            @Override
            public Set<String> qualifiedNames() {
                return this.val$filteredSet;
            }

            @Override
            @Nullable
            public Nullability getNullability(String annotation2) {
                Nullability origNullability = this.val$holder.getNullability(annotation2);
                return this.val$nullabilities.contains((Object)origNullability) ? origNullability : null;
            }
        })) == null || !nullabilities.contains((Object)result2.getNullability()) ? null : result2.getAnnotation();
    }

    @Nullable
    private NullabilityAnnotationInfo findPlainAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean skipExternal, NullabilityAnnotationDataHolder annotations2) {
        PsiAnnotation annotation2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(16);
        }
        AnnotationUtil.AnnotationAndOwner memberAnno = checkBases && owner instanceof PsiMethod ? AnnotationUtil.findAnnotationAndOwnerInHierarchy(owner, annotations2.qualifiedNames(), skipExternal) : ((annotation2 = AnnotationUtil.findAnnotation(owner, annotations2.qualifiedNames(), skipExternal)) == null ? null : new AnnotationUtil.AnnotationAndOwner(owner, annotation2));
        PsiType type2 = NullableNotNullManager.getOwnerType(owner);
        if (memberAnno != null && type2 instanceof PsiArrayType && !AnnotationUtil.isInferredAnnotation(memberAnno.annotation) && !AnnotationUtil.isExternalAnnotation(memberAnno.annotation) && AnnotationTargetUtil.isTypeAnnotation(memberAnno.annotation)) {
            memberAnno = null;
        }
        if (memberAnno != null) {
            Nullability nullability = annotations2.getNullability(memberAnno.annotation.getQualifiedName());
            if (nullability == null) {
                return null;
            }
            nullability = this.correctNullability(nullability, memberAnno.annotation);
            if (type2 != null) {
                for (PsiAnnotation typeAnno : type2.getApplicableAnnotations()) {
                    Nullability typeNullability;
                    if (typeAnno == memberAnno.annotation || (typeNullability = annotations2.getNullability(typeAnno.getQualifiedName())) == null) continue;
                    if (typeNullability != nullability) {
                        return null;
                    }
                    memberAnno = new AnnotationUtil.AnnotationAndOwner(owner, typeAnno);
                    break;
                }
            }
            return new NullabilityAnnotationInfo(memberAnno.annotation, nullability, memberAnno.owner == owner ? null : memberAnno.owner, false);
        }
        if (type2 instanceof PsiPrimitiveType) {
            return null;
        }
        return this.findAnnotationInTypeHierarchy(type2, annotations2);
    }

    @NotNull
    protected Nullability correctNullability(@NotNull Nullability nullability, @NotNull PsiAnnotation annotation2) {
        if (nullability == null) {
            NullableNotNullManager.$$$reportNull$$$0(17);
        }
        if (annotation2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(18);
        }
        Nullability nullability2 = nullability;
        if (nullability2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(19);
        }
        return nullability2;
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        List<String> list2 = this.getNullables();
        if (list2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(22);
        }
        return list2;
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        List<String> list2 = this.getNotNulls();
        if (list2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(23);
        }
        return list2;
    }

    @NotNull
    protected abstract NullabilityAnnotationDataHolder getAllNullabilityAnnotationsWithNickNames();

    protected boolean hasHardcodedContracts(@NotNull PsiElement element) {
        if (element == null) {
            NullableNotNullManager.$$$reportNull$$$0(24);
        }
        return false;
    }

    @Nullable
    private static PsiType getOwnerType(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(25);
        }
        if (owner instanceof PsiVariable) {
            return ((PsiVariable)owner).getType();
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).getReturnType();
        }
        return null;
    }

    public boolean isNullable(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(26);
        }
        return (info = this.findEffectiveNullabilityInfo(owner)) != null && info.getNullability() == Nullability.NULLABLE && (checkBases || info.getInheritedFrom() == null);
    }

    public boolean isNotNull(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(27);
        }
        return (info = this.findEffectiveNullabilityInfo(owner)) != null && info.getNullability() == Nullability.NOT_NULL && (checkBases || info.getInheritedFrom() == null);
    }

    @Nullable
    public NullabilityAnnotationInfo findDefaultTypeUseNullability(@Nullable PsiElement context) {
        if (context == null) {
            return null;
        }
        if (context.getParent() instanceof PsiTypeElement && context.getParent().getParent() instanceof PsiLocalVariable) {
            return null;
        }
        return this.findNullabilityDefault(context, PsiAnnotation.TargetType.TYPE_USE);
    }

    @Nullable
    NullabilityAnnotationInfo findNullityDefaultInHierarchy(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(28);
        }
        return this.findNullabilityDefault(owner, AnnotationTargetUtil.getTargetsForLocation(owner.getModifierList()));
    }

    @Nullable
    private NullabilityAnnotationInfo findNullabilityDefault(@NotNull PsiElement place, PsiAnnotation.TargetType ... placeTargetTypes) {
        if (place == null) {
            NullableNotNullManager.$$$reportNull$$$0(29);
        }
        if (placeTargetTypes == null) {
            NullableNotNullManager.$$$reportNull$$$0(30);
        }
        for (PsiElement element = place.getContext(); element != null; element = element.getContext()) {
            NullabilityAnnotationInfo result2;
            if (element instanceof PsiModifierListOwner && (result2 = this.getNullityDefault((PsiModifierListOwner)element, placeTargetTypes, place, false)) != null) {
                return result2;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName = ((PsiClassOwner)element).getPackageName();
            return this.findNullityDefaultOnPackage(placeTargetTypes, JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName), place);
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo findNullityDefaultOnPackage(PsiAnnotation.TargetType @NotNull [] placeTargetTypes, @Nullable PsiPackage psiPackage, PsiElement context) {
        if (placeTargetTypes == null) {
            NullableNotNullManager.$$$reportNull$$$0(31);
        }
        boolean superPackage = false;
        while (psiPackage != null) {
            NullabilityAnnotationInfo onPkg = this.getNullityDefault(psiPackage, placeTargetTypes, context, superPackage);
            if (onPkg != null) {
                return onPkg;
            }
            superPackage = true;
            psiPackage = psiPackage.getParentPackage();
        }
        return null;
    }

    @Nullable
    abstract NullabilityAnnotationInfo getNullityDefault(@NotNull PsiModifierListOwner var1, PsiAnnotation.TargetType @NotNull [] var2, @NotNull PsiElement var3, boolean var4);

    @NotNull
    public abstract List<String> getNullables();

    @NotNull
    public abstract List<String> getNotNulls();

    public static boolean isNullable(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(32);
        }
        return NullableNotNullManager.getNullability(owner) == Nullability.NULLABLE;
    }

    public static boolean isNotNull(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(33);
        }
        return NullableNotNullManager.getNullability(owner) == Nullability.NOT_NULL;
    }

    @NotNull
    public static Nullability getNullability(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(34);
        }
        Nullability nullability = (info = NullableNotNullManager.getInstance(owner.getProject()).findEffectiveNullabilityInfo(owner)) == null ? Nullability.UNKNOWN : info.getNullability();
        if (nullability == null) {
            NullableNotNullManager.$$$reportNull$$$0(35);
        }
        return nullability;
    }

    @NotNull
    public abstract List<String> getInstrumentedNotNulls();

    public abstract void setInstrumentedNotNulls(@NotNull List<String> var1);

    public static boolean isNullabilityAnnotation(@NotNull PsiAnnotation annotation2) {
        if (annotation2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(36);
        }
        return NullableNotNullManager.getInstance(annotation2.getProject()).getAllNullabilityAnnotationsWithNickNames().getNullability(annotation2.getQualifiedName()) != null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    private NullabilityAnnotationInfo findAnnotationInTypeHierarchy(@Nullable PsiType type2, @NotNull NullabilityAnnotationDataHolder qualifiedNames) {
        if (qualifiedNames == null) {
            NullableNotNullManager.$$$reportNull$$$0(37);
        }
        if (type2 == null) {
            return null;
        }
        Ref<Object> result2 = Ref.create(null);
        InheritanceUtil.processSuperTypes(type2, true, eachType -> {
            NullabilityAnnotationInfo info;
            for (PsiAnnotation annotation2 : eachType.getAnnotations()) {
                String qualifiedName2 = annotation2.getQualifiedName();
                if (!qualifiedNames.qualifiedNames().contains(qualifiedName2)) continue;
                Nullability nullability = qualifiedNames.getNullability(qualifiedName2);
                if (nullability != null) {
                    nullability = this.correctNullability(nullability, annotation2);
                    result2.set(new NullabilityAnnotationInfo(annotation2, nullability, false));
                }
                return false;
            }
            if (!(eachType instanceof PsiClassType)) {
                return true;
            }
            PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly(eachType);
            if (!(targetClass instanceof PsiTypeParameter)) {
                return false;
            }
            if (targetClass.getExtendsListTypes().length == 0 && (info = this.findNullabilityDefault(targetClass, PsiAnnotation.TargetType.TYPE_PARAMETER)) != null) {
                result2.set(info);
                return false;
            }
            return true;
        });
        return result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 22: 
            case 23: 
            case 35: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 22: 
            case 23: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generated";
                break;
            }
            case 8: 
            case 18: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullabilities";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 19: 
            case 22: 
            case 23: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberAnno";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAnno";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeTargetTypes";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "correctNullability";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullablesWithNickNames";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullsWithNickNames";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNullableAnnotation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullAnnotation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyNotNullAnnotation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableAnnotation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableOrNotNullAnnotation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyAnnotation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findOwnNullabilityInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findEffectiveNullabilityInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doFindEffectiveNullabilityAnnotation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultFiltered";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findExplicitNullabilityAnnotation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findPlainAnnotation";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "correctNullability";
                break;
            }
            case 19: 
            case 22: 
            case 23: 
            case 35: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "areDifferentNullityAnnotations";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasHardcodedContracts";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getOwnerType";
                break;
            }
            case 26: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isNullable";
                break;
            }
            case 27: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isNotNull";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultInHierarchy";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findNullabilityDefault";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultOnPackage";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getNullability";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isNullabilityAnnotation";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInTypeHierarchy";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 19: 
            case 22: 
            case 23: 
            case 35: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static interface NullabilityAnnotationDataHolder {
        public Set<String> qualifiedNames();

        @Nullable
        public Nullability getNullability(String var1);
    }
}

