/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceOverloadConflictResolver;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceResolutionKt;
import org.jetbrains.kotlin.resolve.calls.components.CreateFreshVariablesSubstitutor;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.candidate.CallableReferenceResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.components.FreshVariableNewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceCallCandidatesAmbiguity;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.CompatibilityWarning;
import org.jetbrains.kotlin.resolve.calls.model.CompatibilityWarningOnArgument;
import org.jetbrains.kotlin.resolve.calls.model.EagerCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LHSResult;
import org.jetbrains.kotlin.resolve.calls.model.NoneCallableReferenceCallCandidates;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceArgumentAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedExpressionAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SubKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.resolve.calls.tower.VisibilityError;
import org.jetbrains.kotlin.resolve.calls.tower.VisibilityErrorOnArgument;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceArgumentResolver;", "", "callableReferenceOverloadConflictResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceOverloadConflictResolver;", "(Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceOverloadConflictResolver;)V", "getCallableReferenceOverloadConflictResolver", "()Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceOverloadConflictResolver;", "buildResolvedKtArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "lhsResult", "Lorg/jetbrains/kotlin/resolve/calls/model/LHSResult;", "processCallableReferenceArgument", "", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "resolvedAtom", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallableReferenceArgumentAtom;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "resolution"})
@SourceDebugExtension(value={"SMAP\nCallableReferenceArgumentResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableReferenceArgumentResolver.kt\norg/jetbrains/kotlin/resolve/calls/components/CallableReferenceArgumentResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1#2:80\n1726#3,3:81\n1855#3,2:84\n*S KotlinDebug\n*F\n+ 1 CallableReferenceArgumentResolver.kt\norg/jetbrains/kotlin/resolve/calls/components/CallableReferenceArgumentResolver\n*L\n27#1:81,3\n46#1:84,2\n*E\n"})
public final class CallableReferenceArgumentResolver {
    @NotNull
    private final CallableReferenceOverloadConflictResolver callableReferenceOverloadConflictResolver;

    public CallableReferenceArgumentResolver(@NotNull CallableReferenceOverloadConflictResolver callableReferenceOverloadConflictResolver) {
        Intrinsics.checkNotNullParameter(callableReferenceOverloadConflictResolver, "callableReferenceOverloadConflictResolver");
        this.callableReferenceOverloadConflictResolver = callableReferenceOverloadConflictResolver;
    }

    @NotNull
    public final CallableReferenceOverloadConflictResolver getCallableReferenceOverloadConflictResolver() {
        return this.callableReferenceOverloadConflictResolver;
    }

    public final void processCallableReferenceArgument(@NotNull ConstraintSystemBuilder csBuilder, @NotNull ResolvedCallableReferenceArgumentAtom resolvedAtom, @NotNull KotlinDiagnosticsHolder diagnosticsHolder, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        UnwrappedType unwrappedType;
        Intrinsics.checkNotNullParameter(csBuilder, "csBuilder");
        Intrinsics.checkNotNullParameter(resolvedAtom, "resolvedAtom");
        Intrinsics.checkNotNullParameter(diagnosticsHolder, "diagnosticsHolder");
        Intrinsics.checkNotNullParameter(resolutionCallbacks, "resolutionCallbacks");
        CallableReferenceKotlinCallArgument argument = resolvedAtom.getAtom();
        UnwrappedType unwrappedType2 = resolvedAtom.getExpectedType();
        if (unwrappedType2 != null) {
            UnwrappedType it = unwrappedType2;
            boolean bl = false;
            TypeSubstitutorMarker typeSubstitutorMarker = csBuilder.buildCurrentSubstitutor();
            Intrinsics.checkNotNull(typeSubstitutorMarker, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor");
            unwrappedType = ((NewTypeSubstitutor)typeSubstitutorMarker).safeSubstitute(it);
        } else {
            unwrappedType = null;
        }
        UnwrappedType expectedType = unwrappedType;
        Collection<CallableReferenceResolutionCandidate> candidates = resolutionCallbacks.resolveCallableReferenceArgument(resolvedAtom.getAtom(), expectedType, csBuilder.currentStorage());
        if (candidates.size() > 1 && resolvedAtom instanceof EagerCallableReferenceAtom) {
            boolean bl;
            block12: {
                Iterable $this$all$iv = candidates;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        CallableReferenceResolutionCandidate it = (CallableReferenceResolutionCandidate)element$iv;
                        boolean bl2 = false;
                        if (TowerUtilsKt.isInapplicable(it.getResultingApplicability())) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (bl) {
                diagnosticsHolder.addDiagnostic(new CallableReferenceCallCandidatesAmbiguity(argument, candidates));
            }
            resolvedAtom.setAnalyzedResults(null, CollectionsKt.listOf(((EagerCallableReferenceAtom)resolvedAtom).transformToPostponed()));
            return;
        }
        CallableReferenceResolutionCandidate chosenCandidate = (CallableReferenceResolutionCandidate)CollectionsKt.singleOrNull((Iterable)candidates);
        if (chosenCandidate != null) {
            FreshVariableNewTypeSubstitutor toFreshSubstitutor = CreateFreshVariablesSubstitutor.INSTANCE.createToFreshVariableSubstitutorAndAddInitialConstraints(chosenCandidate.getCandidate(), resolvedAtom.getAtom().getCall(), csBuilder);
            CallableReferenceResolutionKt.addConstraints(chosenCandidate, csBuilder, toFreshSubstitutor, argument);
            Iterable $this$forEach$iv = chosenCandidate.getDiagnostics();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinCallDiagnostic it = (KotlinCallDiagnostic)element$iv;
                boolean bl = false;
                KotlinCallDiagnostic kotlinCallDiagnostic = it;
                KotlinCallDiagnostic transformedDiagnostic = kotlinCallDiagnostic instanceof CompatibilityWarning ? (KotlinCallDiagnostic)new CompatibilityWarningOnArgument(argument, ((CompatibilityWarning)it).getCandidate()) : (kotlinCallDiagnostic instanceof VisibilityError ? (KotlinCallDiagnostic)new VisibilityErrorOnArgument(argument, ((VisibilityError)it).getInvisibleMember()) : it);
                diagnosticsHolder.addDiagnostic(transformedDiagnostic);
            }
            chosenCandidate.setFreshVariablesSubstitutor$resolution(toFreshSubstitutor);
        } else if (candidates.isEmpty()) {
            diagnosticsHolder.addDiagnostic(new NoneCallableReferenceCallCandidates(argument));
        } else {
            diagnosticsHolder.addDiagnostic(new CallableReferenceCallCandidatesAmbiguity(argument, candidates));
        }
        List<ResolvedAtom> subKtArguments = CollectionsKt.listOfNotNull(this.buildResolvedKtArgument(argument.getLhsResult()));
        resolvedAtom.setAnalyzedResults(chosenCandidate, subKtArguments);
    }

    private final ResolvedAtom buildResolvedKtArgument(LHSResult lhsResult) {
        ResolvedAtom resolvedAtom;
        if (!(lhsResult instanceof LHSResult.Expression)) {
            return null;
        }
        SimpleKotlinCallArgument lshCallArgument = ((LHSResult.Expression)lhsResult).getLshCallArgument();
        if (lshCallArgument instanceof SubKotlinCallArgument) {
            resolvedAtom = ((SubKotlinCallArgument)lshCallArgument).getCallResult();
        } else if (lshCallArgument instanceof ExpressionKotlinCallArgument) {
            resolvedAtom = new ResolvedExpressionAtom((ExpressionKotlinCallArgument)lshCallArgument);
        } else {
            ArgumentsUtilsKt.unexpectedArgument(lshCallArgument);
            throw null;
        }
        return resolvedAtom;
    }
}

