/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.findings.location;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.conqat.engine.commons.findings.location.ITeamscaleIssueFindingLocation;
import org.conqat.engine.commons.findings.location.ManualTestCaseTextRegionLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.test.IndexValueClass;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=TeamscaleIssueFieldLocation.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ManualTestCaseTextRegionLocation.class, name="ManualTestCaseTextRegionLocation")})
@IndexValueClass(containedInBackup=true)
public class TeamscaleIssueFieldLocation
extends TextRegionLocation
implements ITeamscaleIssueFindingLocation {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="issueId")
    private final String issueId;
    @JsonProperty(value="affectedField")
    private final String affectedField;
    @JsonProperty(value="fieldStartOffset")
    private final int fieldStartOffset;
    @JsonProperty(value="fieldEndOffset")
    private final int fieldEndOffset;
    @JsonProperty(value="fieldStartLine")
    private final int fieldStartLine;
    @JsonProperty(value="fieldEndLine")
    private final int fieldEndLine;

    public TeamscaleIssueFieldLocation(TeamscaleIssueFieldLocation location) {
        super(location);
        this.issueId = location.issueId;
        this.affectedField = location.affectedField;
        this.fieldStartOffset = location.fieldStartOffset;
        this.fieldEndOffset = location.fieldEndOffset;
        this.fieldStartLine = location.fieldStartLine;
        this.fieldEndLine = location.fieldEndLine;
    }

    public TeamscaleIssueFieldLocation(String uniformPath, String issueId, RawAndFieldSpecific startOffset, RawAndFieldSpecific endOffset, RawAndFieldSpecific startLine, RawAndFieldSpecific endLine, String affectedField) {
        super(uniformPath, startOffset.rawValue, endOffset.rawValue, startLine.rawValue, endLine.rawValue);
        this.issueId = issueId;
        this.fieldStartOffset = startOffset.fieldSpecificValue;
        this.fieldEndOffset = endOffset.fieldSpecificValue;
        this.fieldStartLine = startLine.fieldSpecificValue;
        this.fieldEndLine = endLine.fieldSpecificValue;
        this.affectedField = affectedField;
    }

    @Override
    public String getIssueId() {
        return this.issueId;
    }

    public String getAffectedField() {
        return this.affectedField;
    }

    public int getFieldStartOffset() {
        return this.fieldStartOffset;
    }

    public RawAndFieldSpecific getStartOffset() {
        return new RawAndFieldSpecific(this.getRawStartOffset(), this.getFieldStartOffset());
    }

    public int getFieldEndOffset() {
        return this.fieldEndOffset;
    }

    public RawAndFieldSpecific getEndOffset() {
        return new RawAndFieldSpecific(this.getRawEndOffset(), this.getFieldEndOffset());
    }

    public int getFieldStartLine() {
        return this.fieldStartLine;
    }

    public RawAndFieldSpecific getStartLine() {
        return new RawAndFieldSpecific(this.getRawStartLine(), this.getFieldStartLine());
    }

    public int getFieldEndLine() {
        return this.fieldEndLine;
    }

    public RawAndFieldSpecific getEndLine() {
        return new RawAndFieldSpecific(this.getRawEndLine(), this.getFieldEndLine());
    }

    @Override
    public String toLocationString() {
        return String.join((CharSequence)":", this.getUniformPath(), this.getAffectedField(), this.fieldStartLine + "-" + this.fieldEndLine);
    }

    @Override
    public String getLocationKey() {
        return this.toLocationString() + " (offsets: " + this.fieldStartOffset + "-" + this.fieldEndOffset + ")";
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TeamscaleIssueFieldLocation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TeamscaleIssueFieldLocation)) {
            return false;
        }
        TeamscaleIssueFieldLocation that = (TeamscaleIssueFieldLocation)o;
        return that.canEqual(this) && Objects.equals(this.issueId, that.issueId) && Objects.equals(this.affectedField, that.affectedField) && this.fieldStartOffset == that.fieldStartOffset && this.fieldEndOffset == that.fieldEndOffset && this.fieldStartLine == that.fieldStartLine && this.fieldEndLine == that.fieldEndLine && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.issueId, this.affectedField, this.fieldStartOffset, this.fieldEndOffset, this.fieldStartLine, this.fieldEndLine);
    }

    public static class RawAndFieldSpecific {
        private final int rawValue;
        private final int fieldSpecificValue;

        public RawAndFieldSpecific(int rawValue, int fieldSpecificValue) {
            this.rawValue = rawValue;
            this.fieldSpecificValue = fieldSpecificValue;
        }
    }
}

