/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.index.shared.tests.TestExecution;
import org.conqat.engine.sourcecode.coverage.TestUniformPathUtils;

public class TestInfoContainer {
    private final String uniformPath;
    private @Nullable List<String> testLocations;
    private @Nullable String executionUnit;
    private @Nullable String hash;
    private Double durationSeconds;
    private ETestExecutionResult result;
    private @Nullable String message;
    private @Nullable String readableName;
    private @Nullable Map<String, String> properties;
    private @Nullable String externalLink;
    private @Nullable List<String> associatedSpecItems;
    private boolean partOfPartialReport = false;

    public TestInfoContainer(String uniformPath) {
        TestUniformPathUtils.assertIsTestExecutionPath(uniformPath);
        this.uniformPath = uniformPath;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public void setTestLocations(@Nullable List<String> testLocations) {
        this.testLocations = testLocations;
    }

    public boolean isPartOfPartialReport() {
        return this.partOfPartialReport;
    }

    public void setPartOfPartialReport(boolean partOfPartialReport) {
        this.partOfPartialReport = partOfPartialReport;
    }

    public boolean hasTestExecution() {
        return this.result != null || this.durationSeconds != null;
    }

    public TestExecution getTestExecution() {
        ETestExecutionResult result = Optional.ofNullable(this.result).orElse(ETestExecutionResult.PASSED);
        double durationSeconds = Optional.ofNullable(this.durationSeconds).orElse(0.0);
        return TestExecution.Builder.fromUniformPath(this.uniformPath).setDurationInSeconds(durationSeconds).setResult(result).setFailureMessage(this.message).setHash(this.hash).setExternalLink(this.externalLink).setExecutionUnit(this.executionUnit).setAssociatedSpecItems(this.associatedSpecItems).setTestLocations(this.testLocations).build();
    }

    public void setHash(@Nullable String hash) {
        this.hash = hash;
    }

    public void setDurationSeconds(Double durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public void setResult(ETestExecutionResult result) {
        this.result = result;
    }

    public void setExecutionUnit(@Nullable String executionUnit) {
        this.executionUnit = executionUnit;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    public void setReadableName(@Nullable String readableName) {
        this.readableName = readableName;
    }

    public void setProperties(@Nullable Map<String, String> properties) {
        this.properties = properties;
    }

    public void setExternalLink(@Nullable String externalLink) {
        this.externalLink = externalLink;
    }

    public void setAssociatedSpecItems(@Nullable List<String> associatedSpecItems) {
        this.associatedSpecItems = associatedSpecItems;
    }

    public Double getDurationSeconds() {
        return this.durationSeconds;
    }

    public ETestExecutionResult getResult() {
        return this.result;
    }

    public @Nullable Map<String, String> getProperties() {
        return this.properties;
    }

    public @Nullable String getReadableName() {
        return this.readableName;
    }

    public @Nullable String getExternalLink() {
        return this.externalLink;
    }

    public @Nullable List<String> getAssociatedSpecItems() {
        return this.associatedSpecItems;
    }
}

