/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.teamscale.service.framework.impl.provider.GenericConverterBase;
import com.teamscale.service.framework.impl.provider.InvalidValueException;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Provider
public class UniformPathConverterProvider
implements ParamConverterProvider {
    public <P> ParamConverter<P> getConverter(Class<P> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.isAssignableFrom(UniformPath.class)) {
            return new UniformPathConverter(annotations);
        }
        return null;
    }

    private static class UniformPathConverter
    extends GenericConverterBase<UniformPath> {
        private final boolean resolveToCodePath;

        private UniformPathConverter(Annotation[] annotations) {
            super(annotations);
            this.resolveToCodePath = Arrays.stream(annotations).anyMatch(annotation -> annotation.annotationType().equals(ResolveToCodePath.class));
        }

        @Override
        protected UniformPath convert(String uniformPath) throws InvalidValueException {
            if (uniformPath == null) {
                return null;
            }
            try {
                UniformPath converted = UniformPathCompatibilityUtil.convert((String)uniformPath);
                if (this.resolveToCodePath) {
                    converted = converted.resolveToCodePath();
                }
                return converted;
            }
            catch (IllegalArgumentException e) {
                throw new InvalidValueException(e.getMessage(), e);
            }
        }
    }
}

