/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.abap;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@ExportToTypeScript
public enum EAbapObjectType {
    PROG(true, false),
    CLAS(true, false),
    INTF(true, false),
    FUGR(true, false),
    FMOD(false, false),
    ENHO(true, false),
    TYPE(false, true),
    SUSO(false, false),
    TRAN(false, false),
    DOMA(false, true),
    DTEL(false, true),
    STRU(false, true),
    TABL(false, true),
    TTYP(false, true),
    VIEW(false, true),
    UNKNOWN(false, false),
    DDLS(true, false),
    DDLX(true, false),
    DCLS(true, false),
    SRVD(true, false),
    BDEF(true, false);

    public static final EnumSet<EAbapObjectType> ALL_ABAP_DATA_TYPES;
    public static final EnumSet<EAbapObjectType> ALL_DDIC_DATA_TYPES;
    public static final EnumSet<EAbapObjectType> ALL_OO_TYPES;
    public static final EnumSet<EAbapObjectType> ALL_INCLUDE_TYPES;
    public static final EnumSet<EAbapObjectType> ALL_DATABASE_ENTITY_TYPES;
    public static final Set<EAbapObjectType> CDS_OBJECT_TYPES;
    public static final Set<EAbapObjectType> DDIC_OBJECT_TYPES;
    private final boolean isSourceCode;
    private final boolean isDictionary;

    public static EAbapObjectType getValue(String name) {
        return Arrays.stream(EAbapObjectType.values()).filter(a -> a.name().equals(name)).findFirst().orElse(UNKNOWN);
    }

    private EAbapObjectType(boolean isSourceCode, boolean isDictionary) {
        this.isSourceCode = isSourceCode;
        this.isDictionary = isDictionary;
    }

    public boolean isDictionary() {
        return this.isDictionary;
    }

    static {
        ALL_ABAP_DATA_TYPES = EnumSet.of(CLAS, new EAbapObjectType[]{INTF, DTEL, STRU, TABL, TTYP, TYPE, VIEW, DDLS, DDLX, DCLS, SRVD, BDEF});
        ALL_DDIC_DATA_TYPES = EnumSet.of(CLAS, new EAbapObjectType[]{INTF, DTEL, STRU, TABL, TTYP, VIEW});
        ALL_OO_TYPES = EnumSet.of(CLAS, INTF);
        ALL_INCLUDE_TYPES = EnumSet.of(PROG, FUGR);
        ALL_DATABASE_ENTITY_TYPES = EnumSet.of(TABL, VIEW, DDLS);
        CDS_OBJECT_TYPES = EnumSet.of(BDEF, DCLS, DDLS, SRVD);
        DDIC_OBJECT_TYPES = EnumSet.of(DOMA, new EAbapObjectType[]{DTEL, STRU, TABL, TTYP, VIEW});
    }
}

