/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.logging;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class LoggingEventTransport
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String THREAD_CONTEXT_ADDITIONAL_CONTEXT_FIELD = "context";
    private static final String MESSAGE_PROPERTY_NAME = "message";
    private static final String LEVEL_PROPERTY_NAME = "level";
    private static final String TIME_PROPERTY_NAME = "time";
    private static final String THREAD_PROPERTY_NAME = "thread";
    private static final String CONTEXT_DATA_PROPERTY_NAME = "context";
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="level")
    private final ELogLevel level;
    @JsonProperty(value="time")
    private final long time;
    @JsonProperty(value="thread")
    private final @Nullable String thread;
    @JsonProperty(value="context")
    private final Map<String, String> contextData;

    @JsonCreator
    public LoggingEventTransport(@JsonProperty(value="message") String message, @JsonProperty(value="level") ELogLevel level, @JsonProperty(value="time") long time, @JsonProperty(value="thread") @Nullable String thread, @JsonProperty(value="context") @Nullable Map<String, String> contextData) {
        this.message = message;
        this.level = level;
        this.time = time;
        this.thread = thread;
        this.contextData = Optional.ofNullable(contextData).map(HashMap::new).orElseGet(Collections::emptyMap);
    }

    public static LoggingEventTransport of(String message, ELogLevel level) {
        return new LoggingEventTransport(message, level, System.currentTimeMillis(), Thread.currentThread().getName(), ThreadContext.getContext());
    }

    public LoggingEventTransport withMessageBy(UnaryOperator<String> messageOperator) {
        return new LoggingEventTransport((String)messageOperator.apply(this.message), this.level, this.time, this.thread, this.contextData);
    }

    public String getMessage() {
        return this.message;
    }

    public ELogLevel getLevel() {
        return this.level;
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        return this.message;
    }

    public static List<LoggingEventTransport> convertFromLog4j(Collection<LogEvent> logEvents) {
        return CollectionUtils.map(logEvents, LoggingEventTransport::convertFromLog4j);
    }

    private static LoggingEventTransport convertFromLog4j(LogEvent event) {
        return new LoggingEventTransport(LoggingEventTransport.extractMessage(event), ELogLevel.forLog4jLevel(event.getLevel()), event.getTimeMillis(), event.getThreadName(), event.getContextData().toMap());
    }

    private static String extractMessage(LogEvent event) {
        Throwable thrown;
        String context;
        StringJoiner fullMessage = new StringJoiner(StringUtils.LINE_SEPARATOR);
        String message = event.getMessage().getFormattedMessage();
        if (message != null) {
            fullMessage.add(message);
        }
        if ((context = (String)event.getContextData().getValue("context")) != null) {
            fullMessage.add("[Context: " + context + "]");
        }
        if ((thrown = event.getThrown()) != null) {
            fullMessage.add(StringUtils.obtainStackTrace((Throwable)thrown));
        }
        return fullMessage.toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggingEventTransport that = (LoggingEventTransport)o;
        return this.time == that.time && Objects.equals(this.message, that.message) && this.level == that.level;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.message, this.level, this.time});
    }
}

