/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.dotnet.resource;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.dotnet.resource.parser.ESolutionFormatVersion;
import org.conqat.engine.dotnet.resource.parser.ProjectParser;

public class ProjectSourceExtractor {
    public static Set<String> extractRelativePaths(String projectFileContent) throws ConQATException, ESolutionFormatVersion.UnsupportedFormatException {
        return ProjectSourceExtractor.extractAbsolutePaths(projectFileContent, null);
    }

    public static Set<String> extractAbsolutePaths(String projectFileContent, String projectFileUniformPath) throws ConQATException, ESolutionFormatVersion.UnsupportedFormatException {
        ProjectParser.VisualStudioProject project = ProjectParser.parse(projectFileContent);
        Set<String> paths = new TreeSet<String>(project.getRelativeSources());
        if (projectFileUniformPath != null) {
            File pathPrefix = new File(projectFileUniformPath).getParentFile();
            paths = paths.stream().map(path -> new File(pathPrefix, (String)path).getPath().replace("\\", "/")).collect(Collectors.toCollection(TreeSet::new));
        }
        return paths;
    }
}

