/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-assert-commands-always-with-id", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AssertCommandsAlwaysWithIdCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List assertStatements = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT), Set.of("assert"));
        for (ShallowEntity statement : assertStatements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (tokens.size() > 1 && !EnumSet.of(ETokenType.EQ, ETokenType.ARROW).contains(((IToken)tokens.get(1)).getType()) && !TokenStreamUtils.containsAny((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.ID})) {
            this.buildFinding("ASSERT statement without ID", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

