/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.base.EntityCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-boolean-importing-parameter", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class BooleanImportingParameterCheck
extends EntityCheckBase {
    protected String getXPathSelectionString() {
        return "//METHOD";
    }

    protected List<ShallowEntity> filterEntities(List<ShallowEntity> entities) {
        return CollectionUtils.filter(entities, e -> e.getSubtype().equals("method declaration"));
    }

    protected void processEntity(ShallowEntity entity) throws CheckException {
        List parameters = LanguageFeatureParser.ABAP.getTypeInfoForMethodParameters(entity, (List)entity.includedTokens());
        if (entity.getName() != null && entity.getName().startsWith("set_") && parameters.size() == 1) {
            return;
        }
        parameters.stream().filter(this::isImporting).forEach(this::checkParameter);
    }

    private boolean isImporting(TypedVariable typedVariable) {
        return typedVariable.getModifiers().stream().findFirst().map(token -> token.getType() == ETokenType.IMPORTING).orElse(false);
    }

    private void checkParameter(TypedVariable parameter) {
        if (parameter.getTypeName().equalsIgnoreCase("abap_bool")) {
            this.buildFinding("Importing parameter %s of type `abap_bool`".formatted(MarkupUtils.formatAsSourceCode((String)parameter.getVariableName())), this.buildLocation().forToken(this.determineToken(parameter))).createAndStore();
        }
    }

    private IToken determineToken(TypedVariable parameter) {
        return parameter.getDeclaringEntity().includedTokens().stream().filter(token -> LanguageFeatureParser.ABAP.normalizeVariable(token.getText()).equals(parameter.getVariableName())).findFirst().orElseThrow();
    }
}

