/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.base.EntityCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-catch-high-level-abap-exception", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CatchHighLevelAbapExceptionCheck
extends EntityCheckBase {
    protected String getXPathSelectionString() {
        return "//STATEMENT[subtype('catch')]";
    }

    protected void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.includedTokens();
        int catchIndex = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.CATCH);
        if (catchIndex == -1 || tokens.size() <= catchIndex + 1) {
            return;
        }
        IToken exceptionToken = (IToken)tokens.get(catchIndex + 1);
        if (exceptionToken != null && LanguageFeatureParser.ABAP.isGenericExceptionClass(exceptionToken.getText())) {
            this.buildFinding("Catch clause catches generic exception %s".formatted(MarkupUtils.formatAsSourceCode((String)exceptionToken.getText())), this.buildLocation().forToken(exceptionToken)).createAndStore();
        }
    }
}

