/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.abap.AbapCheckUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-no-complex-logic-in-event-block", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoComplexLogicInEventBlockCheck
extends CheckImplementationBase {
    @CheckOption(name="Maximum lines in event block", description="Maximum length of an event block body in number of lines (approximates event block complexity; default: 25).")
    private int maxEventBlockLines = 25;

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!AbapCheckUtils.EVENT_TYPES.contains(method.getSubtype())) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        int length = entity.getEndLine() - entity.getStartLine();
        if (length > this.maxEventBlockLines) {
            this.buildFinding("Event block is longer than " + this.maxEventBlockLines + " lines", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

