/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap_cds;

import eu.cqse.check.abap_cds.AbapCdsCheckUtils;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-abap-cds-avoid-ddic-views", languages={ELanguage.ABAP, ELanguage.ABAP_CDS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidDdicBasedViewsCheck
extends CheckImplementationBase {
    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED;
    }

    public void execute() throws CheckException {
        if (!AbapCdsCheckUtils.isAbapCdsViewDefinition((ITokenElementContext)this.context)) {
            return;
        }
        List methodEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity view : methodEntities) {
            if (!view.getSubtype().equals("View Definition")) continue;
            this.buildFinding("Avoid ddic-based views", this.buildLocation().forEntity(view)).createAndStore();
        }
    }
}

