/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cloud_smells.clike;

import eu.cqse.check.cloud_smells.UnwantedExpressionBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

@Check(id="cqse-avoid-hard-coded-path", languages={ELanguage.CS, ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class HardCodedPathUsageCheck
extends UnwantedExpressionBase {
    protected static final String CHECK_NAME = "Hard Coded Path";
    @CheckOption(name="Hard Coded Path - Allowed drive letters", description="Access to the drive letters specified here is allowed. Separated by commas.")
    private Set<String> allowedDriveLetters = new HashSet<String>();

    @Override
    protected @NonNull EnumSet<EShallowEntityType> getTargetTypes() {
        return EnumSet.of(EShallowEntityType.ATTRIBUTE, EShallowEntityType.STATEMENT);
    }

    @Override
    protected Pattern getUnwantedRegex() {
        return Pattern.compile("[\"'\\s](?i)(?<absolutePath>(?<driveLetter>[a-z]):(?:\\\\{1,2}[a-z0-9_\\-\\s\\.]+)+)");
    }

    @Override
    protected String getFindingText(ShallowEntity entity, MatchResult matchResult) {
        return CHECK_NAME;
    }

    @Override
    protected boolean shouldIgnore(MatchResult matchResult) {
        boolean isAllowedDrivePath = this.allowedDriveLetters.contains(matchResult.group(1));
        return isAllowedDrivePath;
    }
}

