/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.comment;

import eu.cqse.check.base.CommentCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Check(id="cqse-nested-comment", languages={ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVASCRIPT, ELanguage.CS, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.PYTHON})
public class NestedCommentCheck
extends CommentCheckBase {
    private static final String SLASH_SLASH = "//";
    private static final String SLASH_ASTERISK = "/*";
    private static final String HASH = "#";
    private static final String SINGLE_QUOTES = "'''";
    private static final String DOUBLE_QUOTES = "\"\"\"";
    private static final int CLIKE_COMMENT_LENGTH = 2;
    private static final int PYTHON_SINGLE_LINE_COMMENT_LENGTH = 1;
    private static final int PYTHON_MULTI_LINE_COMMENT_LENGTH = 3;
    private static final String NOT_FOUND = "";
    private static final Map<String, List<String>> CLIKE_COMMENT_TO_NESTED_COMMENTS = Map.of("//", Collections.singletonList("/*"), "/*", Arrays.asList("/*", "//"));
    private static final Map<String, List<String>> PYTHON_COMMENT_TO_NESTED_COMMENTS = Map.of("#", Arrays.asList("\"\"\"", "'''"), "'''", Arrays.asList("\"\"\"", "#"), "\"\"\"", Arrays.asList("'''", "#"));
    private static final Map<String, String> CODE_SECTIONS = Map.of("{@code", "}", "<code>", "</code>", "<pre>", "</pre>", "@code", "@endcode", "\\code", "\\endcode", "```", "```");
    private static final String[] CODE_SECTION_OPENING_TAGS = CODE_SECTIONS.keySet().toArray(new String[0]);
    private static final List<String> RAW_STRING_LITERAL_BEGINNINGS = List.of("r'", "r\"", "u'", "u\"");
    private static final Pattern BLOCK_COMMENT_TRAILING_SLASH_PATTERN = Pattern.compile("[^ ]/ *\\n(?![ \\t]*\\*/)[\\t ]*\\*? *[^/*]");
    private static final Pattern QUOTED_TEXT_PATTERN = Pattern.compile("\"[^\"\\n]*\"|'[^'\\n]*'");

    protected void processComment(IToken token, int startLine, int endLine) {
        String nestedComment = this.findNestedComment(token.getText());
        if (!nestedComment.equals(NOT_FOUND)) {
            this.buildFinding("Comment should not contain `" + nestedComment + "`", this.buildLocation().betweenLines(startLine, endLine)).createAndStore();
        }
    }

    @VisibleForTesting
    static String removeUrls(String commentText) {
        List<String> commentLines = StringUtils.splitLinesAsList((String)NestedCommentCheck.removeAsteriskAfterLineWithTrailingSlash(commentText)).stream().map(String::strip).toList();
        StringBuilder result = new StringBuilder();
        for (String line : commentLines) {
            boolean containsUrl = false;
            String alteredLine = line;
            if (line.contains("://")) {
                Matcher matcher = UrlUtils.URL_PATTERN.matcher(line);
                alteredLine = matcher.replaceAll(NOT_FOUND);
                boolean bl = containsUrl = !alteredLine.equals(line);
            }
            if (alteredLine.isEmpty() && containsUrl) continue;
            result.append(alteredLine).append("\n");
        }
        return result.toString();
    }

    private static String removeAsteriskAfterLineWithTrailingSlash(String commentText) {
        return BLOCK_COMMENT_TRAILING_SLASH_PATTERN.matcher(commentText).replaceAll("/");
    }

    private String findNestedComment(String commentText) {
        if (this.context.getLanguage() == ELanguage.PYTHON) {
            return NestedCommentCheck.findNestedCommentForPython(commentText);
        }
        return NestedCommentCheck.findNestedCommentForCLikeLanguages(commentText);
    }

    private static String findNestedCommentForCLikeLanguages(String commentText) {
        CCSMAssert.isTrue((commentText.length() > 1 ? 1 : 0) != 0, (String)"Clike comment should contain at least 2 characters.");
        return NestedCommentCheck.findNestedCommentBasedOnFirstComment(commentText.substring(0, 2), NestedCommentCheck.removeQuotations(NestedCommentCheck.removeCodeSections(NestedCommentCheck.removeUrls(commentText.substring(2)))), CLIKE_COMMENT_TO_NESTED_COMMENTS);
    }

    private static String findNestedCommentForPython(String commentText) {
        CCSMAssert.isFalse((boolean)commentText.isEmpty(), (String)"Python comment should contain at least one character.");
        int firstCommentEndIndex = 1;
        if (!commentText.startsWith(HASH)) {
            firstCommentEndIndex = 3;
        }
        int startIndexOfComment = NestedCommentCheck.getStartIndexOfComment(commentText);
        commentText = commentText.substring(startIndexOfComment);
        return NestedCommentCheck.findNestedCommentBasedOnFirstComment(commentText.substring(0, firstCommentEndIndex), NestedCommentCheck.removeCodeSections(NestedCommentCheck.removeUrls(commentText.substring(firstCommentEndIndex))), PYTHON_COMMENT_TO_NESTED_COMMENTS);
    }

    private static int getStartIndexOfComment(String commentText) {
        for (String rawStringLiteral : RAW_STRING_LITERAL_BEGINNINGS) {
            if (!commentText.startsWith(rawStringLiteral)) continue;
            return 1;
        }
        return 0;
    }

    private static String findNestedCommentBasedOnFirstComment(String firstComment, String restOfComment, Map<String, List<String>> commentToNestedComments) {
        List<String> nestedCommentsForFirstComment = commentToNestedComments.get(firstComment);
        if (nestedCommentsForFirstComment == null) {
            LogManager.getLogger().warn(firstComment + " is not a valid opening tag for comments in the given language. The comment seems to be malformed. Skipping this line.");
            return NOT_FOUND;
        }
        for (String nestedComment : nestedCommentsForFirstComment) {
            if (!restOfComment.contains(nestedComment)) continue;
            return nestedComment;
        }
        return NOT_FOUND;
    }

    @VisibleForTesting
    static String removeCodeSections(String commentText) {
        String openingTag;
        int openingTagIndex = NestedCommentCheck.indexOfOpeningTag(commentText, 0);
        StringBuffer processedCommentText = new StringBuffer(commentText);
        while (openingTagIndex >= 0 && (openingTag = NestedCommentCheck.determineOpeningTag(processedCommentText, openingTagIndex)) != null) {
            int closingTagIndex = NestedCommentCheck.indexOfClosingTag(processedCommentText.toString(), openingTag, openingTagIndex);
            if (closingTagIndex < 0) {
                ++openingTagIndex;
            } else {
                processedCommentText.replace(openingTagIndex, closingTagIndex + CODE_SECTIONS.get(openingTag).length(), NOT_FOUND);
            }
            openingTagIndex = NestedCommentCheck.indexOfOpeningTag(processedCommentText.toString(), openingTagIndex);
        }
        return processedCommentText.toString();
    }

    @VisibleForTesting
    static String removeQuotations(String commentText) {
        return QUOTED_TEXT_PATTERN.matcher(commentText).replaceAll(" ");
    }

    @VisibleForTesting
    static int indexOfOpeningTag(String commentText, int startIndex) {
        return (Integer)StringUtils.indexOfAndFirstMatch((String)commentText, (int)startIndex, (String[])CODE_SECTION_OPENING_TAGS).getFirst();
    }

    @VisibleForTesting
    static @Nullable String determineOpeningTag(CharSequence commentText, int tagIndex) {
        return (String)StringUtils.indexOfAndFirstMatch((String)commentText.toString(), (int)tagIndex, (String[])CODE_SECTION_OPENING_TAGS).getSecond();
    }

    @VisibleForTesting
    static int indexOfClosingTag(String commentText, String openingTag, int openingTagIndex) {
        String closingTag = CODE_SECTIONS.get(openingTag);
        boolean isMarkdownStyle = openingTag.equals(closingTag);
        int openCodeSections = 1;
        for (int index = openingTagIndex + 1; index >= 0 && index != Integer.MAX_VALUE; ++index) {
            int nextOpeningIndex = NestedCommentCheck.indexOfOrMaxValue(commentText, openingTag, index);
            int nextClosingIndex = NestedCommentCheck.indexOfOrMaxValue(commentText, closingTag, index);
            index = Math.min(nextClosingIndex, nextOpeningIndex);
            if (isMarkdownStyle && index != Integer.MAX_VALUE) {
                --openCodeSections;
            } else if (nextOpeningIndex < nextClosingIndex) {
                ++openCodeSections;
            } else if (nextOpeningIndex > nextClosingIndex) {
                --openCodeSections;
            }
            if (openCodeSections > 0) continue;
            return index;
        }
        return -1;
    }

    @VisibleForTesting
    static int indexOfOrMaxValue(String commentText, String tag, int startIndex) {
        int index = commentText.indexOf(tag, startIndex);
        if (index < 0) {
            return Integer.MAX_VALUE;
        }
        return index;
    }
}

