/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.cpp.CppCheckUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

public class CppMethodDeclarationsExtractorPhase
implements IGlobalExtractionPhase<FunctionDeclaration, FunctionDeclaration.FunctionDeclarationAdditionalInformation> {
    private static final Logger LOGGER = LogManager.getLogger();

    public List<FunctionDeclaration> extract(ITokenElementContext fileContext) throws CheckException {
        ArrayList<FunctionDeclaration> externDeclarations = new ArrayList<FunctionDeclaration>();
        List declarations = CheckImplementationBase.select((ShallowEntity)fileContext.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED), (String)"//METHOD");
        for (ShallowEntity declaration : declarations) {
            if (declaration.getName() == null) {
                if (Objects.equals(declaration.getSubtype(), "lambda expression") || Objects.equals(declaration.getSubtype(), "block expression")) continue;
                LOGGER.warn("Can not store function declaration for function without name " + fileContext.getUniformPath() + ":" + declaration.getStartLine() + ". This function will be invisible to some custom checks.");
                continue;
            }
            externDeclarations.add(new FunctionDeclaration(fileContext.getUniformPath(), declaration));
        }
        return externDeclarations;
    }

    public boolean needsAccessByValue() {
        return true;
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.ABSTRACT_SYNTAX_TREE);
    }

    public EnumSet<ELanguage> getLanguages() {
        return LanguageGroups.C_CPP_AND_MS_CLI;
    }

    private static ArrayList<ArrayList<IToken>> extractParameters(ShallowEntity entity) {
        ArrayList<ArrayList<IToken>> parameters = new ArrayList<ArrayList<IToken>>();
        for (List parameter : LanguageFeatureParser.CPP.getSplitParameterTokens(entity)) {
            parameters.add(new ArrayList(parameter));
        }
        return parameters;
    }

    public FunctionDeclaration createValue(String uniformPath, String declaredName, FunctionDeclaration.FunctionDeclarationAdditionalInformation additionalInformation) {
        return new FunctionDeclaration(uniformPath, declaredName, additionalInformation);
    }

    public static TextRegionLocation getLocationOfParameter(String uniformPath, List<IToken> parameter) {
        IToken last = (IToken)CollectionUtils.getLast(parameter);
        Preconditions.checkArgument((last != null ? 1 : 0) != 0, (Object)"Parameters is not allowed to be empty.");
        int startOffset = parameter.get(0).getOffset();
        int endOffset = last.getOffset();
        int startLine = parameter.get(0).getLineNumber() + 1;
        int endLine = last.getLineNumber() + 1;
        return new TextRegionLocation(uniformPath, startOffset, endOffset, startLine, endLine);
    }

    @IndexValueClass
    public static class FunctionDeclaration
    implements IExtractedValue<FunctionDeclarationAdditionalInformation> {
        private final String uniformPath;
        private final String declaredName;
        private final FunctionDeclarationAdditionalInformation additionalInformation;

        private FunctionDeclaration(String uniformPath, ShallowEntity declaration) {
            this.uniformPath = uniformPath;
            CCSMAssert.isNotNull((Object)declaration.getName(), (String)("Can not store function declaration for function without name " + uniformPath + ":" + declaration.getStartLine()));
            this.declaredName = declaration.getName();
            this.additionalInformation = new FunctionDeclarationAdditionalInformation(CppMethodDeclarationsExtractorPhase.extractParameters(declaration), new TextRegionLocation(uniformPath, declaration.getStartOffset(), declaration.getEndOffset(), declaration.getStartLine(), declaration.getEndLine()), CppCheckUtils.extractSignatureLocationFrom((String)uniformPath, (ShallowEntity)declaration));
        }

        private FunctionDeclaration(String uniformPath, String declaredName, FunctionDeclarationAdditionalInformation additionalInformation) {
            this.uniformPath = uniformPath;
            this.declaredName = declaredName;
            this.additionalInformation = additionalInformation;
        }

        public String getUniformPath() {
            return this.uniformPath;
        }

        public String getValue() {
            return this.declaredName;
        }

        public FunctionDeclarationAdditionalInformation getAdditionalInformation() {
            return this.additionalInformation;
        }

        public ArrayList<ArrayList<IToken>> getParameters() {
            return this.additionalInformation.parameters;
        }

        public TextRegionLocation getLocation() {
            return this.additionalInformation.location;
        }

        public TextRegionLocation getSignatureLocation() {
            return this.additionalInformation.signatureLocation;
        }

        @IndexValueClass
        public static final class FunctionDeclarationAdditionalInformation
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final ArrayList<ArrayList<IToken>> parameters;
            private final TextRegionLocation location;
            private final TextRegionLocation signatureLocation;

            private FunctionDeclarationAdditionalInformation(ArrayList<ArrayList<IToken>> parameters, TextRegionLocation location, TextRegionLocation signatureLocation) {
                this.parameters = parameters;
                this.location = location;
                this.signatureLocation = signatureLocation;
            }
        }
    }
}

