/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-encapsulated-assembler", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class EncapsulatedAssemblerCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List allEntities = ShallowEntityTraversalUtils.getAllEntities((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()));
        for (ShallowEntity entity : allEntities) {
            if (!"inline assembler call".equals(entity.getSubtype()) && !"inline assembler block".equals(entity.getSubtype())) continue;
            this.processEntity(entity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        boolean hasMacroAsOrigin;
        boolean isInMethod = entity.getParent().getType() != EShallowEntityType.MODULE;
        boolean isAlone = entity.getParent().getChildren().size() == 1;
        boolean bl = hasMacroAsOrigin = entity.ownStartTokens().size() <= 1 || ((IToken)entity.ownStartTokens().get(0)).getOriginId().equals("##macro##");
        if (isInMethod && !isAlone && !hasMacroAsOrigin) {
            this.buildFinding("Isolation and encapsulation of assembly language is expected", this.buildLocation().betweenLines(entity.getStartLine(), entity.getEndLine())).createAndStore();
        }
    }
}

