/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.sourcecode.coverage.volume.ConditionalStatementSubtypes;
import org.conqat.engine.sourcecode.coverage.volume.condition.Condition;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionEvaluatorBase;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionEvaluatorFactory;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionParserFactory;
import org.conqat.engine.sourcecode.coverage.volume.condition.IConditionExtractor;
import org.conqat.lib.commons.assertion.CCSMAssert;

@Check(id="cqse-repeated-subcondition", languages={ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class RepeatedSubConditionCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private void processEntity(ShallowEntity entity) {
        ELanguage language = this.context.getLanguage();
        if (!ConditionalStatementSubtypes.isConditionalStatement((ShallowEntity)entity, (ELanguage)language) || LanguageFeatureParser.CPP.containsMacroExpandedContent(entity)) {
            return;
        }
        CCSMAssert.isTrue((ConditionParserFactory.supportsLanguage((ELanguage)language) && ConditionEvaluatorFactory.supportsLanguage((ELanguage)language) ? 1 : 0) != 0, (String)"Language not supported.");
        IConditionExtractor conditionExtractor = ConditionParserFactory.createConditionExtractor((ELanguage)language);
        Condition topCondition = conditionExtractor.extractCondition(entity);
        if (topCondition == null) {
            return;
        }
        ConditionEvaluatorBase conditionEvaluator = ConditionEvaluatorFactory.createConditionEvaluator((ELanguage)language);
        List topLevelConditions = conditionEvaluator.splitConditionWithOperatorPrecedence(topCondition);
        ArrayList<List> conditionsToCheck = new ArrayList<List>();
        conditionsToCheck.add(topLevelConditions);
        while (true) {
            ArrayList newConditionsToCheck = new ArrayList();
            for (List list : conditionsToCheck) {
                List<Condition> list2 = this.processSubConditions(list, conditionEvaluator);
                newConditionsToCheck.addAll(conditionEvaluator.splitConditionsWithOperatorPrecedence(list2));
            }
            if (conditionsToCheck.equals(newConditionsToCheck)) break;
            conditionsToCheck = newConditionsToCheck;
        }
    }

    private List<Condition> processSubConditions(List<Condition> subConditions, ConditionEvaluatorBase conditionEvaluator) {
        ArrayList<Condition> uniqueSubConditions = new ArrayList<Condition>();
        for (int i = 0; i < subConditions.size(); ++i) {
            ArrayList<IToken> findingLocation = new ArrayList<IToken>();
            ArrayList<Integer> duplicateConditionIndices = new ArrayList<Integer>();
            for (int j = i + 1; j < subConditions.size(); ++j) {
                if (!conditionEvaluator.conditionEqual(subConditions.get(i), subConditions.get(j))) continue;
                duplicateConditionIndices.add(j);
                findingLocation.addAll((Collection<IToken>)subConditions.get(j).getTokens());
            }
            if (!duplicateConditionIndices.isEmpty()) {
                duplicateConditionIndices.add(0, i);
                this.createFindings(subConditions, findingLocation, duplicateConditionIndices);
                RepeatedSubConditionCheck.removeDuplicateSubConditions(subConditions, duplicateConditionIndices);
                continue;
            }
            uniqueSubConditions.add(subConditions.get(i));
        }
        return uniqueSubConditions;
    }

    private void createFindings(List<Condition> conditions, List<IToken> findingLocation, List<Integer> duplicateConditionIndices) {
        StringBuilder message = new StringBuilder();
        Condition originalCondition = conditions.get(duplicateConditionIndices.get(0));
        findingLocation.addAll(0, (Collection<IToken>)originalCondition.getTokens());
        message.append("Repeated conditional expression: ");
        message.append(originalCondition.getText());
        int messageInsertionMarker = 0;
        boolean addedAdditionalInfo = false;
        for (int i = duplicateConditionIndices.size() - 1; i >= 1; --i) {
            if (originalCondition.equals((Object)conditions.get(duplicateConditionIndices.get(i)))) continue;
            if (!addedAdditionalInfo) {
                message.append(" (equivalent to: ");
                addedAdditionalInfo = true;
                messageInsertionMarker = message.length();
                message.append(conditions.get(i).getText());
                message.append(")");
                continue;
            }
            message.insert(messageInsertionMarker, conditions.get(i).getText() + ", ");
        }
        this.buildFinding(message.toString(), this.buildLocation().forTokens(findingLocation)).createAndStore();
    }

    private static void removeDuplicateSubConditions(List<Condition> conditions, List<Integer> duplicateConditionIndices) {
        for (int i = duplicateConditionIndices.size() - 1; i > 0; --i) {
            conditions.remove(duplicateConditionIndices.get(i));
        }
    }
}

