/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

@Check(id="java:S6246", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AwsLambdaSyncInvokeCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Avoid synchronous calls to other lambdas to prevent scalability issues.";
    private static final int HANDLER_TYPE_GROUP = 0;
    private static final int METHOD_NAME_GROUP = 0;
    private static final ITokenMatcher TOKEN_IN_IMPLEMENTS_LIST = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.COMMA, ETokenType.DOT, ETokenType.LT, ETokenType.GT, ETokenType.QUESTION, ETokenType.EXTENDS, ETokenType.SUPER}).except(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"RequestHandler", "RequestStreamHandler"})});
    private static final TokenPattern LAMBDA_HANDLER_IMPLEMENTS_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.IMPLEMENTS}).repeated(new Object[]{TOKEN_IN_IMPLEMENTS_LIST}).sequence(new Object[]{ITokenMatcher.hasText((String[])new String[]{"RequestHandler", "RequestStreamHandler"})}).group(0);
    private static final TokenPattern TYPE_NAME_SEGMENT = TokenPattern.of().sequence(new Object[]{ETokenType.IDENTIFIER, TokenPattern.of().skipNested((Object)ETokenType.LT, (Object)ETokenType.GT, true)});
    private static final TokenPattern REQUEST_HANDLER_SIGNATURE_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"handleRequest"})}), ETokenType.LPAREN, TokenPattern.of().sequence(new Object[]{TYPE_NAME_SEGMENT}).repeated(new Object[]{ETokenType.DOT, TYPE_NAME_SEGMENT}), ETokenType.IDENTIFIER, ETokenType.COMMA, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"Context"})}), ETokenType.IDENTIFIER, ETokenType.RPAREN});
    private static final TokenPattern REQUEST_STREAM_HANDLER_SIGNATURE_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"handleRequest"})}), ETokenType.LPAREN, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"InputStream"})}), ETokenType.IDENTIFIER, ETokenType.COMMA, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"OutputStream"})}), ETokenType.IDENTIFIER, ETokenType.COMMA, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"Context"})}), ETokenType.IDENTIFIER, ETokenType.RPAREN});
    private static final TokenPattern LAMBDA_INVOKE_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.DOT, ITokenMatcher.hasText((String[])new String[]{"invoke"}), ETokenType.LPAREN}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.RPAREN});
    private static final TokenPattern METHOD_CALL_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.LPAREN});

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.TYPE).stream().filter(entity -> "class".equals(entity.getSubtype())).forEach(this::analyzeIfLambdaHandler);
    }

    private void analyzeIfLambdaHandler(ShallowEntity classEntity) {
        AwsLambdaSyncInvokeCheck.findHandlerMethod(classEntity).ifPresent(handlerMethod -> {
            Map<String, ShallowEntity> methodsInClass = classEntity.getChildren().stream().filter(child -> child.getType() == EShallowEntityType.METHOD).collect(Collectors.toMap(ShallowEntity::getName, method -> method, (existing, replacement) -> existing));
            this.analyzeReachableMethods((ShallowEntity)handlerMethod, methodsInClass);
        });
    }

    private static Optional<ShallowEntity> findHandlerMethod(ShallowEntity classEntity) {
        return Optional.ofNullable(LAMBDA_HANDLER_IMPLEMENTS_PATTERN.findFirstMatch((List)classEntity.ownStartTokens())).map(match -> match.groupString(0)).flatMap(handlerType -> AwsLambdaSyncInvokeCheck.locateHandlerMethod(classEntity, handlerType));
    }

    private static @NonNull Optional<ShallowEntity> locateHandlerMethod(ShallowEntity classEntity, String handlerType) {
        TokenPattern signaturePattern;
        switch (handlerType) {
            case "RequestHandler": {
                TokenPattern tokenPattern = REQUEST_HANDLER_SIGNATURE_PATTERN;
                break;
            }
            case "RequestStreamHandler": {
                TokenPattern tokenPattern = REQUEST_STREAM_HANDLER_SIGNATURE_PATTERN;
                break;
            }
            default: {
                TokenPattern tokenPattern = signaturePattern = null;
            }
        }
        if (signaturePattern == null) {
            return Optional.empty();
        }
        return classEntity.getChildren().stream().filter(child -> EShallowEntityType.METHOD == child.getType() && "handleRequest".equals(child.getName())).filter(method -> signaturePattern.matchesAnywhere((List)method.ownStartTokens())).findFirst();
    }

    private void analyzeReachableMethods(ShallowEntity entryPoint, Map<String, ShallowEntity> methodsInClass) {
        HashSet<ShallowEntity> reachableMethods = new HashSet<ShallowEntity>();
        ArrayDeque<ShallowEntity> worklist = new ArrayDeque<ShallowEntity>();
        worklist.add(entryPoint);
        while (!worklist.isEmpty()) {
            ShallowEntity currentMethod = (ShallowEntity)worklist.poll();
            if (!reachableMethods.add(currentMethod)) continue;
            worklist.addAll(AwsLambdaSyncInvokeCheck.findInternalCallees(currentMethod, methodsInClass));
        }
        reachableMethods.forEach(this::analyzeMethodForSyncInvokes);
    }

    private void analyzeMethodForSyncInvokes(ShallowEntity methodEntity) {
        StateTracker stateTracker = new StateTracker();
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(List.of(methodEntity), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.checkForViolation(statement, stateTracker);
            stateTracker.updateState((List<IToken>)statement.ownStartTokens());
        }
    }

    private void checkForViolation(ShallowEntity statement, StateTracker stateTracker) {
        String invokedVar;
        TokenPatternMatch invokeMatch = LAMBDA_INVOKE_PATTERN.findFirstMatch((List)statement.ownStartTokens());
        if (invokeMatch != null && stateTracker.get(invokedVar = invokeMatch.groupString(0)) == EInvocationState.SYNC) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forEntity(statement)).createAndStore();
        }
    }

    private static Set<ShallowEntity> findInternalCallees(ShallowEntity methodEntity, Map<String, ShallowEntity> allMethods) {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(List.of(methodEntity), (EShallowEntityType)EShallowEntityType.STATEMENT);
        return statements.stream().flatMap(statement -> METHOD_CALL_PATTERN.findAll((List)statement.ownStartTokens()).stream()).map(match -> match.groupString(0)).filter(allMethods::containsKey).map(allMethods::get).collect(Collectors.toSet());
    }

    private static class StateTracker {
        private static final int VAR_NAME_GROUP = 0;
        private static final int VALUE_GROUP = 1;
        private static final TokenPattern INVOKE_REQUEST_DECL_PATTERN = TokenPattern.of().alternative(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"InvokeRequest"})}), ETokenType.VAR}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);
        private static final TokenPattern STATEMENT_START_VAR_PATTERN = TokenPattern.of().beginningOfStream().optional(new Object[]{ETokenType.LPAREN}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);
        private static final TokenPattern INVOCATION_TYPE_SETTER_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.DOT, ITokenMatcher.hasText((String[])new String[]{"setInvocationType", "withInvocationType"}), ETokenType.LPAREN}).sequence(new Object[]{ETokenType.STRING_LITERAL}).group(1).sequence(new Object[]{ETokenType.RPAREN});
        private static final TokenPattern UNKNOWN_SETTER_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.DOT, ITokenMatcher.hasText((String[])new String[]{"setInvocationType", "withInvocationType"}), ETokenType.LPAREN}).notFollowedBy((Object)ETokenType.STRING_LITERAL);
        private static final TokenPattern IDENTIFIER_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);
        private final Map<String, EInvocationState> requestStates = new HashMap<String, EInvocationState>();

        private StateTracker() {
        }

        public void updateState(List<IToken> tokens) {
            if (this.handleVariableDeclaration(tokens) || StateTracker.isInvokeCall(tokens) || this.handleKnownSetters(tokens)) {
                return;
            }
            this.handleUnknownSideEffects(tokens);
        }

        public EInvocationState get(String varName) {
            return this.requestStates.get(varName);
        }

        private boolean handleVariableDeclaration(List<IToken> tokens) {
            TokenPatternMatch declMatch = INVOKE_REQUEST_DECL_PATTERN.findFirstMatch(tokens);
            if (declMatch != null) {
                String varName = declMatch.groupString(0);
                this.requestStates.put(varName, StateTracker.determineInitialStateFromChain(tokens));
                return true;
            }
            return false;
        }

        private static boolean isInvokeCall(List<IToken> tokens) {
            return LAMBDA_INVOKE_PATTERN.matchesAnywhere(tokens);
        }

        private boolean handleKnownSetters(List<IToken> tokens) {
            return Optional.ofNullable(STATEMENT_START_VAR_PATTERN.findFirstMatch(tokens)).map(match -> match.groupString(0)).filter(this.requestStates::containsKey).map(varName -> this.updateStateFromKnownSetters(tokens, (String)varName)).orElse(false);
        }

        private void handleUnknownSideEffects(List<IToken> tokens) {
            IDENTIFIER_PATTERN.findAll(tokens).stream().map(match -> match.groupString(0)).filter(this.requestStates::containsKey).forEach(varName -> this.requestStates.put((String)varName, EInvocationState.UNKNOWN));
        }

        private boolean updateStateFromKnownSetters(List<IToken> tokens, String varName) {
            TokenPatternMatch setterMatch = INVOCATION_TYPE_SETTER_PATTERN.findFirstMatch(tokens);
            if (setterMatch != null) {
                String type = setterMatch.groupString(1);
                if ("\"Event\"".equals(type) || "\"DryRun\"".equals(type)) {
                    this.requestStates.put(varName, EInvocationState.ASYNC);
                } else {
                    this.requestStates.put(varName, EInvocationState.SYNC);
                }
                return true;
            }
            if (UNKNOWN_SETTER_PATTERN.matchesAnywhere(tokens)) {
                this.requestStates.put(varName, EInvocationState.UNKNOWN);
                return true;
            }
            return false;
        }

        private static EInvocationState determineInitialStateFromChain(List<IToken> tokens) {
            return Optional.ofNullable(INVOCATION_TYPE_SETTER_PATTERN.findFirstMatch(tokens)).map(match -> match.groupString(1)).filter(type -> "\"Event\"".equals(type) || "\"DryRun\"".equals(type)).map(type -> EInvocationState.ASYNC).orElse(EInvocationState.SYNC);
        }
    }

    private static enum EInvocationState {
        SYNC,
        ASYNC,
        UNKNOWN;

    }
}

