/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.test.IndexValueClass;

public class CollectClassesPhase
implements IGlobalExtractionPhase<ClassInfo, ClassInfo.DeclarationLocation> {
    private static final Set<String> CONSIDERED_SUBTYPES = Set.of("class", "record", "enum", "enum class");
    private static final JavaLanguageFeatureParser FEATURE_PARSER = LanguageFeatureParser.JAVA;
    private static final String DEFAULT_PACKAGE_NAME = "Default Package";

    private static List<ShallowEntity> extractClasses(ITokenElementContext fileContext) throws CheckException {
        return ShallowEntityTraversalUtils.listEntitiesOfType((Collection)fileContext.getAbstractSyntaxTree(ECodeViewOption.FILTERED), (EShallowEntityType)EShallowEntityType.TYPE).stream().filter(entity -> CONSIDERED_SUBTYPES.contains(entity.getSubtype())).toList();
    }

    private static boolean isNested(ShallowEntity type) {
        Optional parentType = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)type, parent -> parent.getType() == EShallowEntityType.TYPE && CONSIDERED_SUBTYPES.contains(parent.getSubtype()));
        return parentType.isPresent();
    }

    private static List<ClassInfo> buildClassInfos(String uniformPath, String packageName, List<ShallowEntity> types) throws CheckException {
        ArrayList<ClassInfo> collectedClassInfos = new ArrayList<ClassInfo>(types.size());
        for (ShallowEntity entity : types) {
            Optional<IToken> nameTokenOp = entity.ownStartTokens().stream().filter(token -> token.getType() == ETokenType.IDENTIFIER && token.getText().equals(entity.getName())).findFirst();
            IToken nameToken = nameTokenOp.orElseThrow(() -> new CheckException(String.format("Cannot find identifier token for `%s`", entity.ownStartTokens())));
            TextRegionLocation location = new TextRegionLocation(uniformPath, nameToken.getOffset(), nameToken.getEndOffset(), nameToken.getLineNumber() + 1, nameToken.getLineNumber() + 1);
            collectedClassInfos.add(new ClassInfo(entity.getName(), packageName, CollectClassesPhase.isNested(entity), location));
        }
        return collectedClassInfos;
    }

    public List<ClassInfo> extract(ITokenElementContext fileContext) throws CheckException {
        List ast = fileContext.getAbstractSyntaxTree(ECodeViewOption.FILTERED);
        String packageName = FEATURE_PARSER.getPackageName(ast).orElse(DEFAULT_PACKAGE_NAME);
        List<ShallowEntity> classes = CollectClassesPhase.extractClasses(fileContext);
        return CollectClassesPhase.buildClassInfos(fileContext.getUniformPath(), packageName, classes);
    }

    public ClassInfo createValue(String uniformPath, String value, ClassInfo.DeclarationLocation additionalInformation) {
        return new ClassInfo(value, additionalInformation);
    }

    public boolean needsAccessByValue() {
        return true;
    }

    public EnumSet<ELanguage> getLanguages() {
        return EnumSet.of(ELanguage.JAVA, ELanguage.KOTLIN, ELanguage.GROOVY);
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.ABSTRACT_SYNTAX_TREE);
    }

    @IndexValueClass
    public static class ClassInfo
    implements IExtractedValue<DeclarationLocation> {
        private final String className;
        private final DeclarationLocation classLocation;

        private ClassInfo(String className, String classPackage, boolean isNested, TextRegionLocation classLocation) {
            this.className = className;
            this.classLocation = new DeclarationLocation(classPackage, isNested, classLocation);
        }

        private ClassInfo(String className, DeclarationLocation classLocation) {
            this.className = className;
            this.classLocation = classLocation;
        }

        public String getUniformPath() {
            return this.classLocation.location.getUniformPath();
        }

        public String getValue() {
            return this.className;
        }

        public DeclarationLocation getAdditionalInformation() {
            return this.classLocation;
        }

        @IndexValueClass
        public record DeclarationLocation(String packageName, boolean isNested, TextRegionLocation location) implements Serializable
        {
        }
    }
}

