/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class DisabledJunitCheckUtils {
    private static final Set<String> DISABLED_LIKE_FULL_ANNOTATION_NAMES = Set.of("org.junit.Ignore", "org.junit.jupiter.api.Disabled");
    private static final Map<String, String> JUNIT_ANNOTATION_TO_NAMESPACE = new HashMap<String, String>();

    static List<DisabledJUnitCheck> findDisabledJunitTests(List<ShallowEntity> ast) {
        Set junitImports = LanguageFeatureParser.JAVA.getImportsByPrefix(ast, new String[]{"org.junit."});
        List metaEntities = ShallowEntityTraversalUtils.listEntitiesOfType(ast, (EShallowEntityType)EShallowEntityType.META);
        ArrayList<DisabledJUnitCheck> disabledTests = new ArrayList<DisabledJUnitCheck>();
        for (ShallowEntity metaEntity : metaEntities) {
            Optional<String> ignoreAnnotation = DisabledJunitCheckUtils.getIgnoreAnnotation(metaEntity, junitImports);
            ignoreAnnotation.ifPresent(s -> disabledTests.add(DisabledJunitCheckUtils.createResultForIgnoreAnnotation(metaEntity, s)));
        }
        return disabledTests;
    }

    private static Optional<String> getIgnoreAnnotation(ShallowEntity metaEntity, Set<String> junitImports) {
        if (metaEntity.getName() == null || !"annotation".equals(metaEntity.getSubtype())) {
            return Optional.empty();
        }
        if (DISABLED_LIKE_FULL_ANNOTATION_NAMES.contains(metaEntity.getName()) || JUNIT_ANNOTATION_TO_NAMESPACE.containsKey(metaEntity.getName()) && junitImports.contains(JUNIT_ANNOTATION_TO_NAMESPACE.get(metaEntity.getName()) + "." + metaEntity.getName())) {
            return Optional.of(metaEntity.getName());
        }
        for (Map.Entry<String, String> annotationAndNamespace : JUNIT_ANNOTATION_TO_NAMESPACE.entrySet()) {
            if (!junitImports.contains(annotationAndNamespace.getValue() + ".*") || !metaEntity.getName().equals(annotationAndNamespace.getKey())) continue;
            return Optional.of(metaEntity.getName());
        }
        return Optional.empty();
    }

    private static DisabledJUnitCheck createResultForIgnoreAnnotation(ShallowEntity entity, String annotation) {
        List ignoreMessages = TokenStreamUtils.getTokenTextsByType((List)entity.includedTokens(), (ETokenType)ETokenType.STRING_LITERAL);
        if (ignoreMessages.isEmpty() || ((String)ignoreMessages.getFirst()).trim().isEmpty()) {
            return new DisabledJUnitCheck(entity, annotation, null);
        }
        return new DisabledJUnitCheck(entity, annotation, DisabledJunitCheckUtils.removeQuotesFromToken((String)ignoreMessages.getFirst()));
    }

    private static String removeQuotesFromToken(String token) {
        return token.substring(1, token.length() - 1);
    }

    private DisabledJunitCheckUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    static {
        for (String annotationName : DISABLED_LIKE_FULL_ANNOTATION_NAMES) {
            JUNIT_ANNOTATION_TO_NAMESPACE.put(StringUtils.getLastPart((String)annotationName, (char)'.'), StringUtils.removeLastPart((String)annotationName, (char)'.'));
        }
    }

    record DisabledJUnitCheck(ShallowEntity entity, String annotation, @Nullable String rationale) {
    }
}

