/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-multiple-top-level-classes", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MultipleTopLevelClassesCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        if (types.size() <= 1) {
            return;
        }
        for (int i = 1; i < types.size(); ++i) {
            this.buildFinding("More than one top-level class in file", this.buildLocation().forEntityFirstLine((ShallowEntity)types.get(i))).createAndStore();
        }
    }
}

