/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.java.SuspiciousMethodDetector;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-suspicious-methods", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SuspiciousMethodsCheck
extends CheckImplementationBase {
    private static final List<SuspiciousMethodDetector> METHOD_DETECTORS = Arrays.asList(new SuspiciousMethodDetector("equals", 1), new SuspiciousMethodDetector("hashCode", 0), new SuspiciousMethodDetector("toString", 0), new SuspiciousMethodDetector("compareTo", 1));

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!method.getSubtype().equals("method")) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) {
        for (SuspiciousMethodDetector detector : METHOD_DETECTORS) {
            if (!detector.isSuspicious(entity)) continue;
            this.buildFinding("Suspicious method `" + entity.getName() + "`", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
            break;
        }
    }
}

