/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariableUsageTracker {
    private final Map<String, Variable> variableMap = new HashMap<String, Variable>();

    public void setVariableUsed(IToken token) {
        this.addVariable(token).setUsed();
    }

    public void setVariableDeclared(IToken token) {
        this.addVariable(token).setDeclared();
    }

    public List<IToken> getDeclaredButUnusedVariables() {
        ArrayList<IToken> unusedVariables = new ArrayList<IToken>();
        for (Variable variable : this.variableMap.values()) {
            if (!variable.isDeclared() || variable.isUsed()) continue;
            unusedVariables.add(variable.getToken());
        }
        return unusedVariables;
    }

    public List<IToken> getUsedButUndeclaredVariables() {
        ArrayList<IToken> undeclaredVariables = new ArrayList<IToken>();
        for (Variable variable : this.variableMap.values()) {
            if (!variable.isUsed() || variable.isDeclared()) continue;
            undeclaredVariables.add(variable.getToken());
        }
        return undeclaredVariables;
    }

    private Variable addVariable(IToken token) {
        return this.variableMap.computeIfAbsent(token.getText(), key -> new Variable(token));
    }

    private static class Variable {
        private final IToken token;
        private boolean used = false;
        private boolean declared = false;

        Variable(IToken token) {
            this.token = token;
        }

        void setUsed() {
            this.used = true;
        }

        boolean isUsed() {
            return this.used;
        }

        void setDeclared() {
            this.declared = true;
        }

        boolean isDeclared() {
            return this.declared;
        }

        public IToken getToken() {
            return this.token;
        }
    }
}

