/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.plsql;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-cartesian-queries", languages={ELanguage.PLSQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidCartesianQueriesCheck
extends CheckImplementationBase {
    private static final Set<ETokenType> CARTESIAN_PRODUCT_OPERATORS = Set.of(ETokenType.COMMA, ETokenType.CROSS_JOIN);
    private static final TokenPattern CARTESIAN_QUERY_OPERAND = new TokenPattern().sequence(new Object[]{CARTESIAN_PRODUCT_OPERATORS}).sequence(new Object[]{ETokenType.IDENTIFIER}).notFollowedBy((Object)ETokenType.DOT);
    private static final TokenPattern CARTESIAN_QUERY_CANDIDATE_PATTERN = new TokenPattern().sequence(new Object[]{new TokenPattern().notPrecededBy((Object)ETokenType.ASSOCIATION).sequence(new Object[]{ETokenType.IDENTIFIER}).notPrecededBy((Object)ETokenType.DOT).sequence(new Object[]{CARTESIAN_QUERY_OPERAND}).repeated(new Object[]{CARTESIAN_QUERY_OPERAND})}).group(0).repeated(new Object[]{ETokenType.RPAREN}).notFollowedBy((Object)ETokenType.WHERE);

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        List cartesianQueryCandidateMatches = CARTESIAN_QUERY_CANDIDATE_PATTERN.findNonOverlappingMatches((List)tokens);
        for (TokenPatternMatch cartesianQueryCandidateMatch : cartesianQueryCandidateMatches) {
            List cartesianQueryCandidate = cartesianQueryCandidateMatch.groupTokens(0);
            if (AvoidCartesianQueriesCheck.isMatchPartOfParameterList(cartesianQueryCandidateMatch.groupIndices(0), (List<IToken>)tokens)) continue;
            this.buildFinding("Avoid cartesian query " + AvoidCartesianQueriesCheck.buildDisplayStringFromTokens(cartesianQueryCandidate), this.buildLocation().forTokens(cartesianQueryCandidate)).createAndStore();
        }
    }

    private static boolean isMatchPartOfParameterList(List<Integer> groupIndices, List<IToken> tokens) {
        if (TokenStreamUtils.contains(tokens, (ETokenType)ETokenType.CROSS_JOIN)) {
            return false;
        }
        int startIndex = groupIndices.get(0);
        return startIndex > 1 && tokens.get(startIndex - 1).getType().equals((Object)ETokenType.LPAREN) && tokens.get(startIndex - 2).getType().equals((Object)ETokenType.IDENTIFIER);
    }

    private static String buildDisplayStringFromTokens(List<IToken> queryTokens) {
        StringBuilder builder = new StringBuilder("`");
        for (IToken queryToken : queryTokens) {
            builder.append(AvoidCartesianQueriesCheck.buildOperatorDisplayPart(queryToken));
        }
        return builder.append("`").toString();
    }

    private static String buildOperatorDisplayPart(IToken operator) {
        switch (operator.getType()) {
            case COMMA: {
                return operator.getText() + " ";
            }
            case CROSS_JOIN: {
                return " " + operator.getText() + " ";
            }
        }
        return operator.getText();
    }
}

