/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.plsql;

import eu.cqse.check.base.EntityCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.function.Predicate;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-plain-sql-column-count", languages={ELanguage.PLSQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class PlSqlUniqueObjectCountCheck
extends EntityCheckBase {
    private static final String CHECK_NAME = "SQL SELECT INTO unique object count";
    @CheckOption(name="SQL SELECT INTO unique object count - Object Threshold", description="Maximum number of unique objects into which columns of a SQL SELECT INTO statement are selected")
    private int objectThreshold = 5;

    protected void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        int intoIndex = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.INTO);
        if (intoIndex == -1) {
            return;
        }
        int fromIndex = TokenStreamUtils.firstTokenMatching((List)tokens, (int)intoIndex, (ITokenMatcher)ETokenType.FROM);
        if (fromIndex == -1) {
            return;
        }
        List targets = TokenStreamUtils.splitWithNesting(tokens.subList(intoIndex + 1, fromIndex), (ETokenType)ETokenType.COMMA, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        long uniqueObjectCount = targets.stream().filter(Predicate.not(List::isEmpty)).map(target -> (IToken)target.get(0)).map(IToken::getText).distinct().count();
        if (uniqueObjectCount > (long)this.objectThreshold) {
            this.buildFinding("`SQL SELECT INTO` with " + uniqueObjectCount + " unique objects", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    protected String getXPathSelectionString() {
        return "//STATEMENT[subtype('SQL') and name-matches('select')]";
    }
}

