/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python.compatibility;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.python.PythonImportExtractor;
import eu.cqse.check.python.compatibility.PythonImportAwareFindingsPattern;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public abstract class ImportAwarePythonCompatibiltiyCheckBase
extends CheckImplementationBase {
    private UnmodifiableSet<String> imports = CollectionUtils.asUnmodifiable(Collections.emptySet());

    protected abstract List<PythonImportAwareFindingsPattern> getFindingPatterns();

    public void execute() throws CheckException {
        this.imports = CollectionUtils.asUnmodifiable((Set)PythonImportExtractor.extractImports(this.context.getRootEntity(ECodeViewOption.FILTERED)).getKeys());
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processTokens((List<IToken>)statement.ownStartTokens());
            this.processTokens((List<IToken>)statement.ownEndTokens());
        }
    }

    private void processTokens(List<IToken> tokens) {
        List<PythonImportAwareFindingsPattern> patterns = this.getFindingPatterns();
        for (PythonImportAwareFindingsPattern pattern : patterns) {
            for (TokenPatternMatch match : pattern.getMatches(tokens, this.imports)) {
                List matchedTokens = match.groupTokens(0);
                String message = pattern.getFindingsMessage(matchedTokens);
                this.buildFinding(message, this.buildLocation().forTokens(matchedTokens)).createAndStore();
            }
        }
    }
}

