/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.hism.himl_0006", languages={ELanguage.SIMULINK})
public class SimulinkIfElseifElsePatternCheck
extends CheckImplementationBase {
    private static final String EMPTY_ELSE_FINDING_MESSAGE = "Inappropriate if/elseif/else patterns are present in the embedded MATLAB code";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"For every if/elseif/else pattern, add an else statement that includes at least one meaningful comment.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!this.blockContainsScriptWithEmptyOrMissingElseClause(block)) continue;
            this.buildFinding(EMPTY_ELSE_FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private boolean blockContainsScriptWithEmptyOrMissingElseClause(SimulinkBlock block) {
        List scripts = StateflowUtils.extractMatlabScriptsFromBlock((SimulinkBlock)block);
        for (String script : scripts) {
            List tokens = ScannerUtils.getTokens((String)script, (ELanguage)ELanguage.MATLAB, (String)this.context.getUniformPath());
            if (!LanguageFeatureParser.MATLAB.hasEmptyOrMissingElseClause(tokens)) continue;
            return true;
        }
        return false;
    }
}

