/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0650", languages={ELanguage.SIMULINK})
public class SimulinkSwitchBlockInputOutputDatatypeCheck
extends CheckImplementationBase {
    private static final String FINDING = "The switching type block has different data types for its input and output data ports";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Use Data Type Conversion blocks to convert the data type for the input data ports to be the same type as the output data port.");
    private static final Set<String> SWITCHING_BLOCK_TYPES = Set.of("Switch", "MultiPortSwitch");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        SimulinkResolvedDataTypes resolvedDataTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (model == null || resolvedDataTypes == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, SWITCHING_BLOCK_TYPES, (boolean)false, (boolean)false)) {
            this.checkDataInputOfSwitchBlock(block, resolvedDataTypes);
        }
    }

    private void checkDataInputOfSwitchBlock(SimulinkBlock block, SimulinkResolvedDataTypes resolvedDataTypes) {
        Set dataPortInputDataTypes = resolvedDataTypes.getInputDataTypes(block, SimulinkDataTypeUtils.getInputDataPortNumbers((SimulinkBlock)block));
        String outputType = resolvedDataTypes.getResolvedOutputDataTypesForBlock(block, ((SimulinkOutPort)block.getOutPorts().iterator().next()).getIndex());
        if ((dataPortInputDataTypes = CollectionUtils.filterToSet((Collection)dataPortInputDataTypes, type -> !type.equals("Unknown") && !type.equals("NOT_CONNECTED"))).isEmpty() || outputType == null || outputType.equals("Unknown") || outputType.equals("NOT_CONNECTED")) {
            return;
        }
        if (dataPortInputDataTypes.size() > 1 || !dataPortInputDataTypes.contains(outputType)) {
            this.context.buildFinding(FINDING, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

